/*
 * Decompiled with CFR 0.152.
 */
package cn.com.wawa.proxy.api.client;

import cn.com.wawa.proxy.api.bean.ConnectionConfig;
import cn.com.wawa.proxy.api.enums.ProtocolActionEnum;
import cn.com.wawa.proxy.api.event.impl.ClientPushEvent;
import cn.com.wawa.proxy.api.protocol.KeepAliveProtocol;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Preconditions;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.List;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.service.IoHandlerAdapter;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.codec.serialization.ObjectSerializationCodecFactory;
import org.apache.mina.filter.logging.LoggingFilter;
import org.apache.mina.transport.socket.nio.NioSocketConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ConnectionClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectionClient.class);
    private static final String OBJECT_FILTER = "objectFilter";
    private static final String HEART_BEAT = "heartbeat";
    private static final String LOGGERSTR = "logger";
    private ConnectionConfig connectionConfig;
    private IoSession ioSession;
    private NioSocketConnector connector;
    private Long clientId;

    public void connect(String ip, Long clientId) {
        this.connectionConfig = new ConnectionConfig.Builder(7787).setIp(ip).setIdleTime(30).build();
        this.clientId = clientId;
        this.connect();
    }

    private void connect() {
        this.connector = new NioSocketConnector();
        this.connector.setHandler((IoHandler)new IoHandlerAdapter(){

            public void messageReceived(IoSession session, Object message) throws Exception {
                super.messageReceived(session, message);
                KeepAliveProtocol protocol = (KeepAliveProtocol)JSONObject.parseObject((String)JSONObject.toJSONString((Object)message), KeepAliveProtocol.class);
                ConnectionClient.this.consumersReceived(session, protocol);
            }

            public void sessionClosed(IoSession session) throws Exception {
                LOGGER.error("\u670d\u52a1\u7aef\u6b63\u5e38\u5173\u95ed\u4e86\u94fe\u63a5");
                Thread.sleep(5000L);
                ConnectionClient.this.tryConnection();
            }

            public void exceptionCaught(IoSession session, Throwable cause) {
            }
        });
        this.connector.getFilterChain().addLast(LOGGERSTR, (IoFilter)new LoggingFilter());
        this.connector.getFilterChain().addLast(OBJECT_FILTER, (IoFilter)new ProtocolCodecFilter((ProtocolCodecFactory)new ObjectSerializationCodecFactory()));
        this.tryConnection();
    }

    public void tryConnection() {
        ConnectFuture future = null;
        try {
            future = this.connector.connect((SocketAddress)new InetSocketAddress(this.connectionConfig.getIp(), this.connectionConfig.getPort()));
            future.awaitUninterruptibly();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (future != null) {
            this.ioSession = future.getSession();
            KeepAliveProtocol protocol = new KeepAliveProtocol();
            protocol.setAction(ProtocolActionEnum.CREATE_SESSION.getCode());
            protocol.setClientId(this.clientId);
            this.ioSession.write((Object)protocol);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(KeepAliveProtocol protocol) {
        Preconditions.checkNotNull((Object)this.ioSession, (Object)"\u670d\u52a1\u5668\u5df2\u7ecf\u5173\u95ed\u4f1a\u8bdd\u8fde\u63a5");
        IoSession ioSession = this.ioSession;
        synchronized (ioSession) {
            this.ioSession.write((Object)protocol);
        }
    }

    public KeepAliveProtocol createProtocol(ProtocolActionEnum protocolActionEnum) {
        return this.createProtocol(protocolActionEnum, null, null);
    }

    public KeepAliveProtocol createProtocol(ProtocolActionEnum protocolActionEnum, List<String> pushClientKeys, ClientPushEvent clientPushEvent) {
        KeepAliveProtocol keepAliveProtocol = new KeepAliveProtocol();
        keepAliveProtocol.setId(System.currentTimeMillis());
        keepAliveProtocol.setClientPushEvent(clientPushEvent);
        keepAliveProtocol.setAction(protocolActionEnum.getCode());
        return keepAliveProtocol;
    }

    public void close() {
        if (null == this.connector) {
            return;
        }
        if (this.ioSession != null) {
            KeepAliveProtocol closeProtocol = this.createProtocol(ProtocolActionEnum.CLOSE_SESSION);
            this.ioSession.write((Object)closeProtocol);
            this.ioSession.getCloseFuture().setClosed();
            this.ioSession.getCloseFuture().awaitUninterruptibly();
        }
        this.connector.dispose();
    }

    public abstract void consumersReceived(IoSession var1, KeepAliveProtocol var2);

    public ConnectionConfig getConnectionConfig() {
        return this.connectionConfig;
    }

    public NioSocketConnector getConnector() {
        return this.connector;
    }
}

