package cn.com.wawa.proxy.api.enums;

/**
 * Created by danke on 2017/11/20.
 * 协议中通信的action枚举
 */
public enum RequestCodeEnums {

    NOTIFY_MESSAGE(1,"聊天消息通知"),
    WIN_MESSAGE(2,"中奖消息通知"),
    WAWA_STATUS(3,"娃娃机状态推送"),
    CREATE_SESSION(4,"创建会话"),
    CONTROL_COMMAND(5,"控制指令"),
    HOUSE_HEARTBEAT(6,"房间心跳"),
    CLIENT_HEARTBEAT(7,"客户端心跳");


    private int code;
    private String msg;

    RequestCodeEnums(int code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public static RequestCodeEnums getByCode(int code) {
        for (RequestCodeEnums enumVal : RequestCodeEnums.values()) {
            if (code == enumVal.getCode()) {
                return enumVal;
            }
        }
        return null;
    }

    public int getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }
}
