package cn.com.wawa.proxy.api.event;

import cn.com.wawa.proxy.api.enums.RequestCodeEnums;
import cn.com.wawa.proxy.api.event.impl.*;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by danke on 2017/11/14.
 * 通信协议体类型接口
 */
public interface PushEvent {

    Map<Integer,Class<? extends PushEvent>> pushEventClazz = new HashMap(){
        {
            pushEventClazz.put(RequestCodeEnums.NOTIFY_MESSAGE.getCode(), NotifyMessageBody.class);
            pushEventClazz.put(RequestCodeEnums.WIN_MESSAGE.getCode(), WinMessageBody.class);
            pushEventClazz.put(RequestCodeEnums.WAWA_STATUS.getCode(), WawaStatusBody.class);
            pushEventClazz.put(RequestCodeEnums.CREATE_SESSION.getCode(), CreateSessionBody.class);
            pushEventClazz.put(RequestCodeEnums.CONTROL_COMMAND.getCode(), ControlCommandBody.class);
            pushEventClazz.put(RequestCodeEnums.HOUSE_HEARTBEAT.getCode(),HouseHeartBeatBody.class);
        }
    };

    static Class<? extends PushEvent> getPushEventClass(int requestCode){
        return pushEventClazz.get(requestCode);
    }

}
