package cn.com.wawa.proxy.api.protocol;

import cn.com.wawa.proxy.api.event.PushEvent;

import java.io.Serializable;

/**
 * Created by danke on 2017/11/20.
 * 长连接协议定义,客户端与服务端交互的最基本单位
 */
public final class KeepAliveProtocol implements Serializable{

    /**
     * 协议唯一id
     */
    private Long requestId;
    /**
     * 通信标示,客户端注册之后的标号
     */
    private String sessionId;
    /**
     * 发送时间
     */
    private Long sendTime;
    /**
     * 协议请求类型
     */
    private Integer requestCode;
    /**
     * 响应状态码
     */
    private Integer responseCode;
    /**
     * 协议体
     */
    private PushEvent pushEvent;

    public Long getRequestId() {
        return requestId;
    }

    public void setRequestId(Long requestId) {
        this.requestId = requestId;
    }

    public String getSessionId() {
        return sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public Long getSendTime() {
        return sendTime;
    }

    public void setSendTime(Long sendTime) {
        this.sendTime = sendTime;
    }

    public Integer getRequestCode() {
        return requestCode;
    }

    public void setRequestCode(Integer requestCode) {
        this.requestCode = requestCode;
    }

    public Integer getResponseCode() {
        return responseCode;
    }

    public void setResponseCode(Integer responseCode) {
        this.responseCode = responseCode;
    }

    public PushEvent getPushEvent() {
        return pushEvent;
    }

    public void setPushEvent(PushEvent pushEvent) {
        this.pushEvent = pushEvent;
    }
}
