package cn.com.wawa.proxy.api.enums;

import cn.com.wawa.proxy.api.event.PushEvent;
import cn.com.wawa.proxy.api.event.impl.*;

/**
 * Created by danke on 2017/11/20.
 * 协议中通信的action枚举
 */
public enum RequestCodeEnums {

    NOTIFY_MESSAGE(1,"聊天消息通知", NotifyMessageBody.class),
    WIN_MESSAGE(2,"中奖消息通知", WinMessageBody.class),
    WAWA_STATUS(3,"娃娃机状态推送", WawaStatusBody.class),
    CREATE_SESSION(4,"创建会话", CreateSessionBody.class),
    CONTROL_COMMAND(5,"控制指令", ControlCommandBody.class),
    HOUSE_HEARTBEAT(6,"房间心跳",HouseHeartBeatBody.class),
    CLIENT_HEARTBEAT(7,"客户端心跳",null);


    private int code;
    private String msg;
    private Class<? extends PushEvent> body;

    RequestCodeEnums(int code, String msg,Class<? extends PushEvent> clazz) {
        this.code = code;
        this.msg = msg;
        this.body = clazz;
    }

    public static RequestCodeEnums getByCode(int code) {
        for (RequestCodeEnums enumVal : RequestCodeEnums.values()) {
            if (code == enumVal.getCode()) {
                return enumVal;
            }
        }
        return null;
    }

    public int getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public Class<? extends PushEvent> getBody() {
        return body;
    }

    public void setBody(Class<? extends PushEvent> body) {
        this.body = body;
    }
}
