package cn.com.wawa.proxy.api.event;

import cn.com.wawa.proxy.api.enums.RequestCodeEnums;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.StringUtils;

/**
 * Created by danke on 2017/11/14.
 * 通信协议体类型接口
 */
public interface PushEvent {


    static Class<? extends PushEvent> getPushEventClass(int requestCode){
        RequestCodeEnums requestCodeEnums = RequestCodeEnums.getByCode(requestCode);
        if (null == requestCodeEnums)
            return null;
        return requestCodeEnums.getBody();
    }

    static PushEvent getPushEventByCode(String bodyStr,int requestCode){
        Class<? extends PushEvent> clazz = getPushEventClass(requestCode);
        return getPushEentByClass(bodyStr,clazz);
    }

    static PushEvent getPushEentByClass(String bodyStr,Class<? extends PushEvent> clazz){
        if (StringUtils.isBlank(bodyStr) || null == clazz)
            return null;
        return JSONObject.parseObject(bodyStr,clazz);
    }

}
