package cn.com.wawa.proxy.api.protocol;

import com.alibaba.fastjson.JSONObject;

import java.io.Serializable;

/**
 * Created by danke on 2017/11/20.
 * 长连接协议定义,客户端与服务端交互的最基本单位
 */
public final class KeepAliveProtocol implements Serializable{

    /**
     * 协议唯一id
     */
    private Long requestId;
    /**
     * 业务id
     */
    private String bizId;
    /**
     * 发送时间
     */
    private Long sendTime;
    /**
     * 协议请求类型
     */
    private Integer requestCode;
    /**
     * 响应状态码
     */
    private Integer responseCode;
    /**
     * 协议体
     */
    private String body;

    public Long getRequestId() {
        return requestId;
    }

    public void setRequestId(Long requestId) {
        this.requestId = requestId;
    }

    public Long getSendTime() {
        return sendTime;
    }

    public void setSendTime(Long sendTime) {
        this.sendTime = sendTime;
    }

    public Integer getRequestCode() {
        return requestCode;
    }

    public void setRequestCode(Integer requestCode) {
        this.requestCode = requestCode;
    }

    public Integer getResponseCode() {
        return responseCode;
    }

    public void setResponseCode(Integer responseCode) {
        this.responseCode = responseCode;
    }

    public String getBody() {
        return body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    @Override
    public String toString() {
        return JSONObject.toJSONString(this);
    }

    public String getBizId() {
        return bizId;
    }

    public void setBizId(String bizId) {
        this.bizId = bizId;
    }
}
