package cn.com.wawa.proxy.api.util;

import cn.com.duiba.wolf.utils.BlowfishUtils;

/**
 * ClassName: SecureTool <br/>
 * date: 2017年6月1日 下午9:03:45 <br/>
 *
 * @author zhanglihui
 * @version
 *
 */
public class SecureTool {

    private static String loginKey;

    private SecureTool(){
    }

    /**
     * 解密用户cookie信息
     * @param data
     * @return 解密后的字符串
     */
    public static String decryptToken(String data){
        return BlowfishUtils.decryptBlowfish(data, loginKey);
    }

    /**
     * 加密用户cookie信息
     * @author zhanglihui
     * @param data
     * @return 加密后的字符串
     */
    public static String encryptToken(String data){
        return BlowfishUtils.encryptBlowfish(data, loginKey);
    }

    /**
     *
     * @param loginKey
     */
    public static void setLoginKey(String loginKey) {
        SecureTool.loginKey = loginKey;
    }

}
