package cn.com.wawa.proxy.api.util;

import cn.com.wawa.proxy.api.constant.Constants;
import org.apache.commons.lang3.StringUtils;

import java.net.InetAddress;
import java.net.UnknownHostException;

/**
 * Created by danke on 2017/11/21.
 * 用于生成key标示的工具
 */
public class KeyUtil {

    private KeyUtil() {
    }

    static {
        try {
            localHost = InetAddress.getLocalHost().getHostAddress();
        } catch (UnknownHostException e) {
            e.printStackTrace();
        }
    }

    private static String localHost;

    private static String redisClientNumKey;

    /**
     * 用于生成redis中获取连接数量的key
     * @return
     */
    public static String createClientNumKey(String ip){
        StringBuilder sb = new StringBuilder();
        sb.append(Constants.RedisKey.WAWA_CLIENT_NUM_PROFILE).append(ip);
        return sb.toString();
    }

    /**
     * 该方法只用于服务器本身获取rediskey
     * 不可用于其他项目调用方调用
     * @return
     */
    public static String getLocalClientNumKey(){
        if (StringUtils.isNotBlank(redisClientNumKey))
            return redisClientNumKey;
        StringBuilder sb = new StringBuilder();
        sb.append(Constants.RedisKey.WAWA_CLIENT_NUM_PROFILE).append(localHost);
        redisClientNumKey = sb.toString();
        return redisClientNumKey;
    }

    /**
     * 获取当前服务器的ip地址
     * @return
     */
    public static String getLocalHost(){
        return localHost;
    }

}
