/*
 * Decompiled with CFR 0.152.
 */
package cn.com.wawa.proxy.api.codec;

import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolEncoder;
import org.apache.mina.filter.codec.ProtocolEncoderOutput;

public class HEncoder
implements ProtocolEncoder {
    private final Charset charset;
    public static final int DEFAULT_PREFIX_LENGTH = 4;
    public static final int DEFAULT_MAX_DATA_LENGTH = 2048;
    private int prefixLength = 4;
    private int maxDataLength = 2048;

    public HEncoder(Charset charset) {
        this.charset = charset;
    }

    public void encode(IoSession session, Object message, ProtocolEncoderOutput out) throws Exception {
        CharsetEncoder ce = this.charset.newEncoder();
        IoBuffer buffer = IoBuffer.allocate((int)64).setAutoExpand(true);
        buffer.setAutoExpand(true);
        buffer.putString((CharSequence)message.toString(), ce);
        buffer.flip();
        out.write((Object)buffer);
    }

    public void dispose(IoSession session) throws Exception {
    }

    public void setPrefixLength(int prefixLength) {
        if (prefixLength != 1 && prefixLength != 2 && prefixLength != 4) {
            throw new IllegalArgumentException("prefixLength: " + prefixLength);
        }
        this.prefixLength = prefixLength;
    }

    public int getPrefixLength() {
        return this.prefixLength;
    }

    public void setMaxDataLength(int maxDataLength) {
        this.maxDataLength = maxDataLength;
    }

    public int getMaxDataLength() {
        return this.maxDataLength;
    }
}

