/*
 * Decompiled with CFR 0.152.
 */
package cn.com.wawa.proxy.api.client;

import cn.com.wawa.proxy.api.bean.ConnectionConfig;
import cn.com.wawa.proxy.api.codec.HCoderFactory;
import cn.com.wawa.proxy.api.enums.RequestCodeEnums;
import cn.com.wawa.proxy.api.protocol.KeepAliveProtocol;
import cn.com.wawa.proxy.api.protocol.KeepAliveProtocolHead;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Preconditions;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.service.IoHandlerAdapter;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.logging.LoggingFilter;
import org.apache.mina.transport.socket.nio.NioSocketConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ConnectionClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectionClient.class);
    private static final String OBJECT_FILTER = "objectFilter";
    private static final String HEART_BEAT = "heartbeat";
    private static final String LOGGERSTR = "logger";
    private ConnectionConfig connectionConfig;
    private IoSession ioSession;
    private NioSocketConnector connector;
    private String sessionId;

    public void connect(String ip, String token, String bizId, RequestCodeEnums requestCodeEnums) {
        this.connectionConfig = new ConnectionConfig.Builder(7787).setIp(ip).setIdleTime(30).build();
        this.connect(token, bizId, requestCodeEnums);
    }

    private void connect(String token, String bizId, RequestCodeEnums requestCodeEnums) {
        this.connector = new NioSocketConnector();
        this.connector.setHandler((IoHandler)new IoHandlerAdapter(){

            public void messageReceived(IoSession session, Object message) throws Exception {
                if (null == message) {
                    return;
                }
                super.messageReceived(session, message);
                String messageStr = String.valueOf(message);
                JSONObject jsonObject = JSONObject.parseObject((String)messageStr);
                ConnectionClient.this.consumersReceived(session, jsonObject);
            }

            public void sessionClosed(IoSession session) throws Exception {
                LOGGER.error("\u670d\u52a1\u7aef\u6b63\u5e38\u5173\u95ed\u4e86\u94fe\u63a5");
            }

            public void exceptionCaught(IoSession session, Throwable cause) {
            }
        });
        this.connector.getFilterChain().addLast(LOGGERSTR, (IoFilter)new LoggingFilter());
        this.connector.getFilterChain().addLast("codec", (IoFilter)new ProtocolCodecFilter((ProtocolCodecFactory)new HCoderFactory()));
        this.tryConnection(token, bizId, requestCodeEnums);
    }

    public void tryConnection(String token, String bizId, RequestCodeEnums requestCodeEnums) {
        ConnectFuture future = null;
        try {
            future = this.connector.connect((SocketAddress)new InetSocketAddress(this.connectionConfig.getIp(), this.connectionConfig.getPort()));
            future.awaitUninterruptibly();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (future != null) {
            this.ioSession = future.getSession();
            JSONObject protocol = new JSONObject();
            KeepAliveProtocolHead protocolHead = new KeepAliveProtocolHead();
            protocolHead.setAct(requestCodeEnums.getCode());
            protocolHead.setFrom(bizId);
            protocolHead.setSign(token);
            protocol.put("head", (Object)protocolHead);
            String protocolStr = protocol.toJSONString();
            this.ioSession.write((Object)protocolStr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String protocol) {
        Preconditions.checkNotNull((Object)this.ioSession, (Object)"\u670d\u52a1\u5668\u5df2\u7ecf\u5173\u95ed\u4f1a\u8bdd\u8fde\u63a5");
        IoSession ioSession = this.ioSession;
        synchronized (ioSession) {
            this.ioSession.write((Object)protocol);
        }
    }

    public KeepAliveProtocol createProtocol() {
        KeepAliveProtocol keepAliveProtocol = new KeepAliveProtocol();
        return keepAliveProtocol;
    }

    public void close() {
        if (null == this.connector) {
            return;
        }
        if (this.ioSession != null) {
            // empty if block
        }
        this.connector.dispose();
    }

    public abstract void consumersReceived(IoSession var1, JSONObject var2);

    public ConnectionConfig getConnectionConfig() {
        return this.connectionConfig;
    }

    public NioSocketConnector getConnector() {
        return this.connector;
    }

    public String getSessionId() {
        return this.sessionId;
    }
}

