/*
 * Decompiled with CFR 0.152.
 */
package cn.com.wawa.proxy.api.code;

import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.CumulativeProtocolDecoder;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;

public class HDecoder
extends CumulativeProtocolDecoder {
    public static final int DEFAULT_PREFIX_LENGTH = 4;
    public static final int DEFAULT_MAX_DATA_LENGTH = 2048;
    private int prefixLength = 4;
    private int maxDataLength = 2048;
    private final ClassLoader classLoader;
    private int maxObjectSize = 0x100000;

    public HDecoder() {
        this(Thread.currentThread().getContextClassLoader());
    }

    public HDecoder(ClassLoader classLoader) {
        if (classLoader == null) {
            throw new IllegalArgumentException("classLoader");
        }
        this.classLoader = classLoader;
    }

    public int getMaxObjectSize() {
        return this.maxObjectSize;
    }

    public void setMaxObjectSize(int maxObjectSize) {
        if (maxObjectSize <= 0) {
            throw new IllegalArgumentException("maxObjectSize: " + maxObjectSize);
        }
        this.maxObjectSize = maxObjectSize;
    }

    protected boolean doDecode(IoSession session, IoBuffer in, ProtocolDecoderOutput out) throws Exception {
        if (in.remaining() > 4) {
            in.mark();
            byte[] l = new byte[4];
            in.get(l);
            int len = l.length;
            if (in.remaining() < len) {
                in.reset();
                return false;
            }
            in.reset();
            int sumlen = 4 + len;
            byte[] packArr = new byte[sumlen];
            in.get(packArr, 0, sumlen);
            IoBuffer buffer = IoBuffer.allocate((int)sumlen);
            buffer.put(packArr);
            buffer.flip();
            out.write((Object)buffer);
            buffer.free();
            if (in.remaining() > 0) {
                return true;
            }
        }
        return false;
    }
}

