/*
 * Decompiled with CFR 0.152.
 */
package cn.com.wawa.proxy.api.code;

import java.io.NotSerializableException;
import java.io.Serializable;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolEncoderAdapter;
import org.apache.mina.filter.codec.ProtocolEncoderOutput;

public class HEncoder
extends ProtocolEncoderAdapter {
    public static final int DEFAULT_PREFIX_LENGTH = 4;
    public static final int DEFAULT_MAX_DATA_LENGTH = 2048;
    private int prefixLength = 4;
    private int maxDataLength = 2048;
    private int maxObjectSize = Integer.MAX_VALUE;

    public int getMaxObjectSize() {
        return this.maxObjectSize;
    }

    public void setMaxObjectSize(int maxObjectSize) {
        if (maxObjectSize <= 0) {
            throw new IllegalArgumentException("maxObjectSize: " + maxObjectSize);
        }
        this.maxObjectSize = maxObjectSize;
    }

    public void encode(IoSession session, Object message, ProtocolEncoderOutput out) throws Exception {
        if (!(message instanceof Serializable)) {
            throw new NotSerializableException();
        }
        IoBuffer buf = IoBuffer.allocate((int)64);
        buf.setAutoExpand(true);
        buf.putObject(message);
        int objectSize = buf.position() - 4;
        if (objectSize > this.maxObjectSize) {
            throw new IllegalArgumentException("The encoded object is too big: " + objectSize + " (> " + this.maxObjectSize + ')');
        }
        buf.flip();
        out.write((Object)buf);
    }
}

