package cn.com.wawa.proxy.api.code;

import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolEncoder;
import org.apache.mina.filter.codec.ProtocolEncoderAdapter;
import org.apache.mina.filter.codec.ProtocolEncoderOutput;
import org.apache.mina.filter.codec.prefixedstring.PrefixedStringEncoder;

import java.io.NotSerializableException;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;

/**
 * Created by danke on 2017/11/14.
 */
public class HEncoder extends ProtocolEncoderAdapter {

    private final Charset charset;

    public HEncoder(Charset charset) {
        this.charset = charset;
    }

    @Override
    public void encode(IoSession session, Object message,
                       ProtocolEncoderOutput out) throws Exception {
        StringBuilder sb = new StringBuilder();
        CharsetEncoder ce = charset.newEncoder();
        IoBuffer buffer = IoBuffer.allocate(message.toString().length()).setAutoExpand(true);
        String messageStr = message.toString();
        //这边拼接完整消息长度
        sb.append(String.valueOf("1000")).append(messageStr);
        buffer.putString(sb.toString(),ce);
        buffer.flip();
        out.write(buffer);
    }
}
