package cn.com.wawa.proxy.api.code;

import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.CumulativeProtocolDecoder;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;

import java.nio.charset.Charset;

/**
 * Created by danke on 2017/11/14.
 */
public class HDecoder extends CumulativeProtocolDecoder {

    private final Charset charset;

    public HDecoder(Charset charset) {
        this.charset = charset;
    }

    @Override
    protected boolean doDecode(IoSession arg0, IoBuffer in,
                               ProtocolDecoderOutput arg2) throws Exception {
/*        CharsetDecoder cd = charset.newDecoder();
        String head = message.getString(cd);
        arg2.write(head);*/
        if(in.remaining() > 4){//前4字节是包头
            //标记当前position的快照标记mark，以便后继的reset操作能恢复position位置
            in.mark();
            byte[] l = new byte[4];
            in.get(l);

            String lengthStr = new String(l,"UTF-8");
            int len = Integer.valueOf(lengthStr);
            //注意上面的get操作会导致下面的remaining()值发生变化
            if(in.remaining() < len){
                //如果消息内容不够，则重置恢复position位置到操作前,进入下一轮, 接收新数据，以拼凑成完整数据
                in.reset();
                return false;
            }else{
                //消息内容足够
                in.reset();//重置恢复position位置到操作前
                int sumlen = 4+len;//总长 = 包头+包体
                byte[] packArr = new byte[sumlen];
                in.get(packArr, 0 , sumlen);
                String msg = new String(packArr,"utf-8");
                String tureMsg = msg.substring(4);
                arg2.write(tureMsg);

                if(in.remaining() > 0){//如果读取一个完整包内容后还粘了包，就让父类再调用一次，进行下一次解析
                    return true;
                }
            }
        }
        return false;//处理成功，让父类进行接收下个包
    }


}
