package cn.com.wawa.proxy.api.client;

import cn.com.wawa.proxy.api.bean.ConnectionConfig;
import cn.com.wawa.proxy.api.code.HCodeFactory;
import cn.com.wawa.proxy.api.constant.Constants;
import cn.com.wawa.proxy.api.protocol.KeepAliveProtocol;
import com.alibaba.fastjson.JSONObject;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.service.IoHandlerAdapter;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.logging.LoggingFilter;
import org.apache.mina.transport.socket.nio.NioSocketConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.net.InetSocketAddress;
import java.util.Timer;
import java.util.TimerTask;

/**
 * Created by danke on 2017/11/15.
 */
public abstract class ConnectionClient {

    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectionClient.class);

    private static final String OBJECT_FILTER = "objectFilter";
    private static final String HEART_BEAT = "heartbeat";
    private static final String LOGGERSTR = "logger";

    //链接配置
    private ConnectionConfig connectionConfig;
    //链接会话
    private IoSession ioSession;
    //客户端链接
    private NioSocketConnector connector;
    //该客户端能够被业务服务器识别的id
    private String sessionId;

    private Timer timer;

    public void connect(String ip,String createProtocol){//初始化
        this.connectionConfig = new ConnectionConfig.Builder(Constants.MainConstants.port).setIp(ip).setIdleTime(30).build();
        connect(createProtocol);
        timer = new Timer();
        timer.scheduleAtFixedRate(new TimerTask() {
            @Override
            public void run() {
                JSONObject protocol = new JSONObject();
                JSONObject protocolHead = new JSONObject();
                protocolHead.put("act",0);
                protocol.put("head",protocolHead);
                write(protocol.toJSONString());
            }
        },10*1000,15*1000);
    }

    private void connect(String createProtocol) {
        connector = new NioSocketConnector();
        connector.setHandler(new IoHandlerAdapter() {
            @Override
            public void messageReceived(IoSession session, Object message) throws Exception {
                if (null == message)
                    return;
                super.messageReceived(session, message);
                String messageStr = String.valueOf(message);
                consumersReceived(session,messageStr);
            }

            /**
             * 客户端正常关闭向服务端发送关闭消息
             * @param session
             * @throws Exception
             */
            @Override
            public void sessionClosed(IoSession session) throws Exception {
                LOGGER.error("服务端正常关闭了链接");
/*                Thread.sleep(5000);
                tryConnection();*/
            }

            /**
             * 异常关闭向服务器发送关闭事件
             * @param session
             * @param cause
             * @throws Exception
             */
            @Override
            public void exceptionCaught(IoSession session, Throwable cause){

            }
        });

        connector.getFilterChain().addLast(LOGGERSTR, new LoggingFilter());
        connector.getFilterChain().addLast("codec", new ProtocolCodecFilter(new HCodeFactory()));
        //connector.getFilterChain().addLast(OBJECT_FILTER, new ProtocolCodecFilter(new ObjectSerializationCodecFactory()));
        tryConnection(createProtocol);

    }

    public void tryConnection(String createProtocol){
        ConnectFuture future = null;
        try {
            future = connector.connect(new InetSocketAddress(connectionConfig.getIp(), connectionConfig.getPort()));
            future.awaitUninterruptibly();
        } catch (Exception e) {
            e.printStackTrace();
        }
        if (future != null) {
            //第一次链接时自报家门
            this.ioSession = future.getSession();
            ioSession.write(createProtocol);
        }
    }

    /**
     * 会话推送消息
     * @param protocol
     */
    public void write(String protocol){
        synchronized (ioSession){
            ioSession.write(protocol);
        }
    }

    /**
     * 组建协议
     * 协议类型:客户端发送的消息只会是请求类型
     * 动作:暂时只有事件推送,可使用默认值
     * 推送的clientKey
     * @return
     */
    public KeepAliveProtocol createProtocol(){
        KeepAliveProtocol keepAliveProtocol = new KeepAliveProtocol();
        return keepAliveProtocol;
    }


    public void close(){
        if (null == connector)
            return;
        if (ioSession != null){
            //创建关闭连接消息
        }
        connector.dispose();
    }

    /**
     * 该方法接收服务端推送信息,具体业务需自己实现
     * 参数已经约定序列化完成
     * @param session
     * @param message
     */
    public abstract void consumersReceived(IoSession session, String message);

    public ConnectionConfig getConnectionConfig() {
        return connectionConfig;
    }

    public NioSocketConnector getConnector() {
        return connector;
    }

    public String getSessionId() {
        return sessionId;
    }
}
