/*
 * Decompiled with CFR 0.152.
 */
package cn.com.wawa.proxy.api.client;

import cn.com.wawa.proxy.api.bean.ConnectionConfig;
import cn.com.wawa.proxy.api.code.HCodeFactory;
import cn.com.wawa.proxy.api.protocol.KeepAliveProtocol;
import com.alibaba.fastjson.JSONObject;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.service.IoHandlerAdapter;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.logging.LoggingFilter;
import org.apache.mina.transport.socket.nio.NioSocketConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ConnectionClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectionClient.class);
    private static final String OBJECT_FILTER = "objectFilter";
    private static final String HEART_BEAT = "heartbeat";
    private static final String LOGGERSTR = "logger";
    private ConnectionConfig connectionConfig;
    private IoSession ioSession;
    private NioSocketConnector connector;
    private String sessionId;
    private Timer timer;

    public void connect(String ip, String createProtocol) {
        this.connectionConfig = new ConnectionConfig.Builder(7787).setIp(ip).setIdleTime(30).build();
        this.connect(createProtocol);
        this.timer = new Timer();
        this.timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                JSONObject protocol = new JSONObject();
                JSONObject protocolHead = new JSONObject();
                protocolHead.put("act", (Object)0);
                protocol.put("head", (Object)protocolHead);
                ConnectionClient.this.write(protocol.toJSONString());
            }
        }, 10000L, 15000L);
    }

    private void connect(String createProtocol) {
        this.connector = new NioSocketConnector();
        this.connector.setHandler((IoHandler)new IoHandlerAdapter(){

            public void messageReceived(IoSession session, Object message) throws Exception {
                if (null == message) {
                    return;
                }
                super.messageReceived(session, message);
                String messageStr = String.valueOf(message);
                ConnectionClient.this.consumersReceived(session, messageStr);
            }

            public void sessionClosed(IoSession session) throws Exception {
                LOGGER.error("\u670d\u52a1\u7aef\u6b63\u5e38\u5173\u95ed\u4e86\u94fe\u63a5");
            }

            public void exceptionCaught(IoSession session, Throwable cause) {
            }
        });
        this.connector.getFilterChain().addLast(LOGGERSTR, (IoFilter)new LoggingFilter());
        this.connector.getFilterChain().addLast("codec", (IoFilter)new ProtocolCodecFilter((ProtocolCodecFactory)new HCodeFactory()));
        this.tryConnection(createProtocol);
    }

    public void tryConnection(String createProtocol) {
        ConnectFuture future = null;
        try {
            future = this.connector.connect((SocketAddress)new InetSocketAddress(this.connectionConfig.getIp(), this.connectionConfig.getPort()));
            future.awaitUninterruptibly();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (future != null) {
            this.ioSession = future.getSession();
            this.ioSession.write((Object)createProtocol);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String protocol) {
        IoSession ioSession = this.ioSession;
        synchronized (ioSession) {
            this.ioSession.write((Object)protocol);
        }
    }

    public KeepAliveProtocol createProtocol() {
        KeepAliveProtocol keepAliveProtocol = new KeepAliveProtocol();
        return keepAliveProtocol;
    }

    public void close() {
        if (null == this.connector) {
            return;
        }
        if (this.ioSession != null) {
            // empty if block
        }
        this.connector.dispose();
    }

    public abstract void consumersReceived(IoSession var1, String var2);

    public ConnectionConfig getConnectionConfig() {
        return this.connectionConfig;
    }

    public NioSocketConnector getConnector() {
        return this.connector;
    }

    public String getSessionId() {
        return this.sessionId;
    }
}

