/*
 * Decompiled with CFR 0.152.
 */
package cn.com.wawa.proxy.api.enums;

import cn.com.wawa.proxy.api.enums.RequestCodeEnums;

public enum SessionTypeEnums {
    USER(1, "\u548c\u7528\u6237\u5efa\u7acb\u7684\u4f1a\u8bdd"),
    MACHINE(2, "\u548c\u5a03\u5a03\u673a\u5efa\u7acb\u7684\u4f1a\u8bdd"),
    SERVICE(3, "\u548c\u4e1a\u52a1\u670d\u52a1\u5668\u5efa\u7acb\u7684\u4f1a\u8bdd");

    private int code;
    private String msg;

    public static SessionTypeEnums getByCode(int code) {
        for (SessionTypeEnums enumVal : SessionTypeEnums.values()) {
            if (code != enumVal.getCode()) continue;
            return enumVal;
        }
        return null;
    }

    public static SessionTypeEnums getByRequestCode(int requestCode) {
        RequestCodeEnums requestCodeEnums = RequestCodeEnums.getByCode(requestCode);
        if (null == requestCodeEnums) {
            return null;
        }
        switch (requestCodeEnums) {
            case CREATE_USER: {
                return USER;
            }
            case CREATE_MACHINE: {
                return MACHINE;
            }
            case CREATE_SERVICE: {
                return SERVICE;
            }
            case TO_USER: {
                return USER;
            }
            case TO_MACHINE: {
                return MACHINE;
            }
            case TO_SERVICE: {
                return SERVICE;
            }
        }
        return null;
    }

    private SessionTypeEnums(int code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }
}

