/*
 * Decompiled with CFR 0.152.
 */
package cn.com.wawa.proxy.api.client;

import cn.com.wawa.proxy.api.bean.ConnectionConfig;
import cn.com.wawa.proxy.api.code.HCodeFactory;
import cn.com.wawa.proxy.api.enums.RequestCodeEnums;
import cn.com.wawa.proxy.api.protocol.KeepAliveProtocolHead;
import cn.com.wawa.proxy.api.protocol.KeyPair;
import com.alibaba.fastjson.JSONObject;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.mina.core.RuntimeIoException;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.service.IoHandlerAdapter;
import org.apache.mina.core.service.IoService;
import org.apache.mina.core.service.IoServiceListener;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.transport.socket.nio.NioSocketConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ConnectionClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectionClient.class);
    private static final String LOGGERSTR = "logger";
    private static final int DEFAULT_TIMER_LATE = 10000;
    private static final int DEFAULT_TIMER_TIMING = 15000;
    private ConnectionConfig connectionConfig;
    private IoSession ioSession;
    private NioSocketConnector connector;
    private String userId;
    private RequestCodeEnums act;
    private int timerLate;
    private int timerTimming;
    private Timer timer;
    private AtomicBoolean flag = new AtomicBoolean(true);
    private AtomicBoolean heartFlag = new AtomicBoolean(false);

    public void connect(String userId, RequestCodeEnums act) {
        this.connect(userId, act, 10000, 15000);
    }

    public void connect(String userId, RequestCodeEnums act, Integer timerLate, Integer timerTimming) {
        KeyPair<String, String> ipAndToken = this.getIpAndToken();
        this.connectionConfig = new ConnectionConfig.Builder(7787).setIp(ipAndToken.getFirstOne()).setIdleTime(30).build();
        this.timerLate = null == timerLate ? 10000 : timerLate;
        this.timerTimming = null == timerTimming ? 15000 : timerTimming;
        this.userId = userId;
        this.act = act;
        JSONObject protocol = new JSONObject();
        KeepAliveProtocolHead protocolHead = new KeepAliveProtocolHead();
        protocolHead.setAct(act.getCode());
        protocolHead.setFrom(userId);
        protocolHead.setSign(ipAndToken.getSecondOne());
        protocol.put("head", (Object)protocolHead);
        try {
            this.connect(protocol.toJSONString());
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.timer = new Timer();
        this.timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                if (!ConnectionClient.this.heartFlag.get()) {
                    return;
                }
                JSONObject protocol = new JSONObject();
                JSONObject protocolHead = new JSONObject();
                protocolHead.put("act", (Object)0);
                protocol.put("head", (Object)protocolHead);
                ConnectionClient.this.write(protocol.toJSONString());
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("heart beat send msg={}", (Object)protocol);
                }
            }
        }, timerLate.intValue(), (long)timerTimming.intValue());
    }

    private void connect(String createProtocol) throws InterruptedException {
        try {
            this.connector = new NioSocketConnector();
        }
        catch (RuntimeIoException e) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
            this.connect(createProtocol);
        }
        this.connector.setHandler((IoHandler)new IoHandlerAdapter(){

            public void messageReceived(IoSession session, Object message) throws Exception {
                if (null == message) {
                    return;
                }
                super.messageReceived(session, message);
                String messageStr = String.valueOf(message);
                ConnectionClient.this.consumersReceived(session, messageStr);
            }

            public void sessionClosed(IoSession session) throws Exception {
                LOGGER.error("\u670d\u52a1\u7aef\u6b63\u5e38\u5173\u95ed\u4e86\u94fe\u63a5");
                ConnectionClient.this.heartFlag.set(Boolean.FALSE);
                ConnectionClient.this.doSessionClosed(session);
            }
        });
        this.connector.addListener((IoServiceListener)new IoListener(){

            @Override
            public void sessionDestroyed(IoSession arg0) throws Exception {
                if (!ConnectionClient.this.flag.get()) {
                    return;
                }
                ConnectionClient.this.interruptToConnection();
            }
        });
        this.connector.getFilterChain().addLast("codec", (IoFilter)new ProtocolCodecFilter((ProtocolCodecFactory)new HCodeFactory()));
        this.tryConnection(createProtocol);
    }

    public void tryConnection(String createProtocol) throws InterruptedException {
        ConnectFuture future = null;
        future = this.connector.connect((SocketAddress)new InetSocketAddress(this.connectionConfig.getIp(), this.connectionConfig.getPort()));
        future.await(4000L);
        if (future != null) {
            this.ioSession = future.getSession();
            this.ioSession.write((Object)createProtocol);
            this.heartFlag.set(Boolean.TRUE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String protocol) {
        IoSession ioSession = this.ioSession;
        synchronized (ioSession) {
            System.out.println("\u5411\u670d\u52a1\u5668\u53d1\u9001\u6307\u4ee4");
            if (!this.ioSession.isConnected() || this.ioSession.isClosing()) {
                System.out.println("session\u5173\u95ed,\u5ba2\u6237\u7aef\u5f00\u59cb\u65ad\u7ebf\u91cd\u8fde");
                this.interruptToConnection();
            }
            this.ioSession.write((Object)protocol);
        }
    }

    public void close(Boolean needReTry) {
        if (null == this.connector) {
            return;
        }
        if (this.ioSession != null) {
            this.ioSession.getCloseFuture().setClosed();
        }
        this.connector.dispose();
        this.flag.set(needReTry);
    }

    public abstract void consumersReceived(IoSession var1, String var2);

    public void doSessionClosed(IoSession session) {
    }

    public abstract KeyPair<String, String> getIpAndToken();

    private void interruptToConnection() {
        while (true) {
            try {
                System.out.println("\u5f00\u59cb\u65ad\u7ebf\u91cd\u8fde");
                Thread.sleep(3000L);
                if (null != this.connector) {
                    this.connector.dispose();
                    this.connector = null;
                }
                KeyPair<String, String> ipAndToken = this.getIpAndToken();
                this.connectionConfig = new ConnectionConfig.Builder(7787).setIp(ipAndToken.getFirstOne()).setIdleTime(30).build();
                JSONObject protocol = new JSONObject();
                KeepAliveProtocolHead protocolHead = new KeepAliveProtocolHead();
                protocolHead.setAct(this.act.getCode());
                protocolHead.setFrom(this.userId);
                protocolHead.setSign(ipAndToken.getSecondOne());
                protocol.put("head", (Object)protocolHead);
                this.connect(protocol.toJSONString());
                System.out.println("\u65ad\u7ebf\u91cd\u8fde\u6210\u529f");
            }
            catch (Exception e) {
                LOGGER.info("\u91cd\u8fde\u670d\u52a1\u5668\u767b\u5f55\u5931\u8d25,3\u79d2\u518d\u8fde\u63a5\u4e00\u6b21:" + e.getMessage());
                continue;
            }
            break;
        }
    }

    public ConnectionConfig getConnectionConfig() {
        return this.connectionConfig;
    }

    public NioSocketConnector getConnector() {
        return this.connector;
    }

    public String getUserId() {
        return this.userId;
    }

    public int getTimerLate() {
        return this.timerLate;
    }

    public int getTimerTimming() {
        return this.timerTimming;
    }

    public AtomicBoolean getFlag() {
        return this.flag;
    }

    public AtomicBoolean getHeartFlag() {
        return this.heartFlag;
    }

    private static class IoListener
    implements IoServiceListener {
        private IoListener() {
        }

        public void serviceActivated(IoService arg0) throws Exception {
        }

        public void serviceDeactivated(IoService arg0) throws Exception {
        }

        public void serviceIdle(IoService arg0, IdleStatus arg1) throws Exception {
        }

        public void sessionCreated(IoSession arg0) throws Exception {
        }

        public void sessionDestroyed(IoSession arg0) throws Exception {
        }
    }
}

