package cn.com.wawa.proxy.api.code;

import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.CumulativeProtocolDecoder;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;

import java.nio.charset.Charset;

/**
 * Created by danke on 2018/1/24.
 */
public class HDecoder2 extends CumulativeProtocolDecoder {

    private final Charset charset;

    private static final int LENGTH_BYTE = 4;

    public HDecoder2(Charset charset) {
        this.charset = charset;
    }

    @Override
    protected boolean doDecode(IoSession arg0, IoBuffer in, ProtocolDecoderOutput out) throws Exception {
        if (in.remaining() < LENGTH_BYTE) {
            return false;
        }
        in.mark();

        //取前 4 byte 消息长度
        byte[] offset = new byte[LENGTH_BYTE];
        in.get(offset);
        int length = byteToInt(offset);

        //消息不够，继续读取
        if (in.remaining() < length) {
            in.reset();
            return false;
        }
        //读取到指定长度数据
        byte[] data = new byte[length];
        in.get(data, 0, length);

        out.write(new String(data, charset));

        if (in.remaining() > 0) {
            return true;
        }

        return false;
    }

    private static int byteToInt(byte[] b) {
        int intValue = 0;
        for (int i = 0; i < b.length; i++) {
            intValue += (b[i] & 0xFF) << (8 * (3 - i));
        }
        return intValue;
    }
}
