package cn.com.wawa.proxy.api.code;

import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolEncoderAdapter;
import org.apache.mina.filter.codec.ProtocolEncoderOutput;

import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;

/**
 * Created by danke on 2018/1/24.
 */
public class HEncoder2 extends ProtocolEncoderAdapter {

    private static final int LENGTH_BYTE = 4;  // 消息长度字节

    public static final long MAX_LENGTH = -1L ^ -1L << 31;  // 消息长度最大32-1个bit

    private final Charset charset;

    public HEncoder2(Charset charset) {
        this.charset = charset;
    }

    @Override
    public void encode(IoSession session, Object obj, ProtocolEncoderOutput out) throws Exception {
        CharsetEncoder ce = charset.newEncoder();
        String msg = obj.toString();
        byte[] body = msg.getBytes();
        //byte[] offset = intToByte(msg.length());
        byte[] offset = intToByte(body.length);
        byte[] data = new byte[offset.length + body.length];
        System.arraycopy(offset, 0, data, 0, offset.length);
        System.arraycopy(body, 0, data, offset.length, body.length);
        String message = new String(data,Charset.forName("ISO8859-1"));
        IoBuffer buffer = IoBuffer.allocate(data.length).setAutoExpand(true);
        buffer.putString(message, ce);
        buffer.flip();
        out.write(buffer);
    }

    private static byte[] intToByte(int intValue) {
        if (intValue > MAX_LENGTH) {
            throw new RuntimeException("消息长度不能超过" + MAX_LENGTH);
        }
        byte[] b = new byte[LENGTH_BYTE];
        for (int i = 0; i < LENGTH_BYTE; i++) {
            b[i] = (byte) (intValue >> 8 * (3 - i) & 0xFF);
        }
        return b;
    }
}
