package cn.com.wawa.proxy.api.code;

import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolDecoder;
import org.apache.mina.filter.codec.ProtocolEncoder;

import java.nio.charset.Charset;

/**
 * Created by danke on 2017/11/14.
 */
public class HCodeFactory implements ProtocolCodecFactory {

    private final HEncoder2 encoder;
    private final HDecoder2 decoder;

    public HCodeFactory() {
        this(Charset.defaultCharset());
    }
    public HCodeFactory(Charset charSet) {
        this.encoder = new HEncoder2(charSet);
        this.decoder = new HDecoder2(charSet);
    }

    public ProtocolEncoder getEncoder(IoSession session) {
        return encoder;
    }

    public ProtocolDecoder getDecoder(IoSession session) {
        return decoder;
    }

}
