/*
 * Decompiled with CFR 0.152.
 */
package cn.com.wawa.proxy.api.client;

import cn.com.wawa.proxy.api.code.HCodeFactory;
import cn.com.wawa.proxy.api.enums.RequestCodeEnums;
import cn.com.wawa.proxy.api.protocol.KeepAliveProtocolHead;
import cn.com.wawa.proxy.api.protocol.KeyPair;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.service.IoHandlerAdapter;
import org.apache.mina.core.service.IoService;
import org.apache.mina.core.service.IoServiceListener;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.transport.socket.nio.NioSocketConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MinaClient {
    private static final Logger logger = LoggerFactory.getLogger(MinaClient.class);
    private NioSocketConnector connector;
    private IoSession ioSession;
    private String clientId;
    private RequestCodeEnums act;
    private static ScheduledThreadPoolExecutor scheduled = new ScheduledThreadPoolExecutor(1);

    public void connect(String clientId, RequestCodeEnums act) {
        this.clientId = clientId;
        this.act = act;
        this.connector = new NioSocketConnector();
        this.connector.setConnectTimeoutMillis(5000L);
        this.connector.getSessionConfig().setIdleTime(IdleStatus.READER_IDLE, 60);
        this.connector.getFilterChain().addLast("codec", (IoFilter)new ProtocolCodecFilter((ProtocolCodecFactory)new HCodeFactory()));
        this.connector.setHandler((IoHandler)new ClientIoHandlerAdapter());
        this.connector.addListener((IoServiceListener)new ClientIoListener(){

            @Override
            public void sessionDestroyed(IoSession session) throws Exception {
                MinaClient.this.retryConnect();
            }
        });
        this.startKeepAlive();
    }

    public void write(String message) {
        if (this.ioSession == null || !this.ioSession.isConnected() || this.ioSession.isClosing()) {
            throw new RuntimeException("ioSession is close");
        }
        this.ioSession.write((Object)message);
    }

    private void startKeepAlive() {
        scheduled.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.currentThread().setName("keepAlive");
                    if (MinaClient.this.ioSession == null || !MinaClient.this.ioSession.isConnected() || MinaClient.this.ioSession.isClosing()) {
                        MinaClient.this.retryConnect();
                    }
                    JSONObject protocol = new JSONObject();
                    JSONObject protocolHead = new JSONObject();
                    protocolHead.put("act", (Object)RequestCodeEnums.HEART_CHECK.getCode());
                    protocol.put("head", (Object)protocolHead);
                    MinaClient.this.write(protocol.toJSONString());
                }
                catch (Exception e) {
                    logger.error("scheduleWithFixedDelay", (Throwable)e);
                }
            }
        }, 0L, 30L, TimeUnit.SECONDS);
    }

    private synchronized void retryConnect() {
        while (true) {
            try {
                if (this.ioSession != null && this.ioSession.isConnected()) {
                    return;
                }
                KeyPair<String, String> ipAndToken = this.getIpAndToken();
                logger.info("tryConnect server ip:" + ipAndToken.getFirstOne() + " port:" + 7787 + " token:" + ipAndToken.getSecondOne());
                ConnectFuture future = this.connector.connect((SocketAddress)new InetSocketAddress(ipAndToken.getFirstOne(), 7787));
                future.awaitUninterruptibly();
                this.ioSession = future.getSession();
                if (this.ioSession.isConnected()) {
                    JSONObject protocol = new JSONObject();
                    KeepAliveProtocolHead protocolHead = new KeepAliveProtocolHead();
                    protocolHead.setAct(this.act.getCode());
                    protocolHead.setFrom(this.clientId);
                    protocolHead.setSign(ipAndToken.getSecondOne());
                    protocol.put("head", (Object)protocolHead);
                    this.ioSession.write((Object)protocol.toJSONString());
                    logger.info("connect success");
                    return;
                }
            }
            catch (Exception e) {
                logger.error("connect error:" + e.getMessage());
            }
            try {
                Thread.sleep(3000L);
                continue;
            }
            catch (InterruptedException e) {
                logger.error("Thread.sleep", (Throwable)e);
                continue;
            }
            break;
        }
    }

    protected abstract void msgReceived(String var1);

    protected abstract KeyPair<String, String> getIpAndToken();

    private class ClientIoListener
    implements IoServiceListener {
        private ClientIoListener() {
        }

        public void serviceActivated(IoService service) throws Exception {
        }

        public void serviceIdle(IoService service, IdleStatus idleStatus) throws Exception {
        }

        public void serviceDeactivated(IoService service) throws Exception {
        }

        public void sessionCreated(IoSession session) throws Exception {
        }

        public void sessionDestroyed(IoSession session) throws Exception {
        }
    }

    private class ClientIoHandlerAdapter
    extends IoHandlerAdapter {
        private ClientIoHandlerAdapter() {
        }

        public void sessionClosed(IoSession session) throws Exception {
            MinaClient.this.ioSession.close(true);
        }

        public void sessionIdle(IoSession session, IdleStatus status) throws Exception {
            if (session == IdleStatus.READER_IDLE) {
                MinaClient.this.ioSession.close(true);
            }
        }

        public void exceptionCaught(IoSession session, Throwable cause) throws Exception {
            if (cause instanceof IOException) {
                MinaClient.this.ioSession.close(true);
            }
        }

        public void messageReceived(IoSession session, Object message) throws Exception {
            String msg = message.toString();
            try {
                JSONObject jsonObject = JSONObject.parseObject((String)msg);
                String headStr = jsonObject.getString("head");
                KeepAliveProtocolHead head = (KeepAliveProtocolHead)JSONObject.parseObject((String)headStr, KeepAliveProtocolHead.class);
                if (head.getAct().intValue() == RequestCodeEnums.HEART_CHECK.getCode()) {
                    return;
                }
            }
            catch (Exception e) {
                logger.error("messageReceived", (Throwable)e);
            }
            MinaClient.this.msgReceived(msg);
        }
    }
}

