package cn.com.wawa.proxy.api.enums;

/**
 * Created by danke on 2017/11/20.
 * 协议中通信的action枚举
 */
public enum RequestCodeEnums {

    HEART_CHECK(0,"心跳检测"),
    CREATE_USER(1,"创建用户端连接"),
    CREATE_MACHINE(2,"创建机器端连接"),
    CREATE_SERVICE(3,"创建业务服务器连接"),
    TO_USER(4,"发送给用户端"),
    TO_MACHINE(5,"发送给机器"),
    TO_SERVICE(6,"发送给业务服务器");


    private int code;
    private String msg;

    RequestCodeEnums(int code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public static RequestCodeEnums getByCode(int code) {
        for (RequestCodeEnums enumVal : RequestCodeEnums.values()) {
            if (code == enumVal.getCode()) {
                return enumVal;
            }
        }
        return null;
    }

    public int getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }
}
