package cn.lili.common.lock;

import lombok.extern.slf4j.Slf4j;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.concurrent.TimeUnit;

@Component
@Slf4j
public class DistributedLock {

    @Autowired
    private RedissonClient redissonClient;

    public void execute(String lockName,Runnable runnable, Long waitTime,Long keepTime) {
        // 获取分布式锁对象
        RLock lock = redissonClient.getLock(lockName);
        try {
            // 尝试获取锁
            boolean isLocked = lock.tryLock(waitTime, keepTime, TimeUnit.SECONDS);
            if (isLocked) {
                // 执行业务逻辑
                runnable.run();
            } else {
                // 获取锁失败，处理相应逻辑
                log.error("获取锁失败... {}",lockName);
            }
        } catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        } finally {
            // 释放锁
            lock.unlock();
        }
    }

    public void execute(String lockName,Runnable runnable) {
        // 默认 最多等待10秒，持有锁时间为5秒
        execute(lockName,runnable,10L,5L);
    }

    public <T> T executeWithResult(String lockName,LockCallback<T> callback, Long waitTime,Long keepTime) {
        // 获取分布式锁对象
        RLock lock = redissonClient.getLock(lockName);

        try {
            // 尝试获取锁
            boolean isLocked = lock.tryLock(waitTime, keepTime, TimeUnit.SECONDS);
            if (isLocked) {
                // 执行业务逻辑
                return callback.execute();
            } else {
                // 获取锁失败，处理相应逻辑
                log.error("获取锁失败... {}",lockName);
                return null;
            }
        } catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        } finally {
            // 释放锁
            lock.unlock();
        }
    }

    public <T> T executeWithResult(String lockName,LockCallback<T> callback) {
        return executeWithResult(lockName,callback,10L,5L);
    }

}
