package cn.lili.common.processor;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.stereotype.Component;

/**
 * 在项目中同时使用 Spring Boot Admin 和 Feign Client 时,警告处理
 *
 * @author paulG
 * @since 2022/3/22
 **/
@Component
public class CustomBeanFactoryPostProcessor implements BeanFactoryPostProcessor {
    @Override
    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        BeanDefinition bd1 = beanFactory.getBeanDefinition("feignContext");
        bd1.setDependsOn("registrationListener");

//        BeanDefinition bd2 = beanFactory.getBeanDefinition("springClientFactory");
//        bd2.setDependsOn("registrationListener");
    }
}
