package cn.lili.common.redisExt;

import org.springframework.beans.factory.FactoryBean;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;

import javax.annotation.PostConstruct;
import javax.annotation.Resource;

/**
 * @Author yuquanfeng
 * @Date 2023/5/26
 * @Description
 * @Param
 * @return
 **/
public class JedisConnectionFactoryBean implements FactoryBean<JedisConnectionFactory> {

    @Resource
    private RedisExtProperties redisExtProperties;

    private String extraRedisTemplateIdPrefix;

    private JedisConnectionFactory jedisConnectionFactory;

    public JedisConnectionFactoryBean(String extraRedisTemplateIdPrefix) {
        this.extraRedisTemplateIdPrefix = extraRedisTemplateIdPrefix;
    }

    private RedisExtProperties getRedisProperties() {
        return redisExtProperties.getExtra().get(extraRedisTemplateIdPrefix);
    }


    @PostConstruct
    public void init() {
        JedisConnectionConfiguration fc = new JedisConnectionConfiguration(getRedisProperties());
        JedisConnectionFactory factory = fc.redisConnectionFactory();
        factory.afterPropertiesSet();
        jedisConnectionFactory = factory;
    }

    @Override
    public JedisConnectionFactory getObject() throws Exception {
        return jedisConnectionFactory;
    }

    @Override
    public Class<?> getObjectType() {
        return JedisConnectionFactory.class;
    }

    @Override
    public boolean isSingleton() {
        return true;
    }

    public void destroy() {
        if (jedisConnectionFactory != null) {
            jedisConnectionFactory.destroy();
        }
    }
}
