package cn.lili.common.threadpool.wrapper;

import cn.lili.common.threadpool.factory.NamedThreadFactory;
import cn.lili.common.threadpool.policy.AbortPolicyWithReport;
import cn.lili.common.threadpool.properties.ThreadPoolProperties;
import org.springframework.context.SmartLifecycle;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.*;

/**
 * @Author yuquanfeng
 * @Date 2023/5/25
 * @Description
 * @Param
 * @return
 **/
public class ThreadPoolExecutorWrapper extends ThreadPoolTaskExecutor implements AsyncTaskExecutor, ExecutorService, SmartLifecycle {


    public ThreadPoolExecutorWrapper(String threadPoolName, ThreadPoolProperties poolProperties){
        setThreadNamePrefix(threadPoolName);

        Objects.requireNonNull(threadPoolName);
        Objects.requireNonNull(poolProperties);
        setRejectedExecutionHandler(new AbortPolicyWithReport(threadPoolName));
        setThreadFactory(new NamedThreadFactory(threadPoolName));
        setCorePoolSize(poolProperties.getCoreSize());
        setMaxPoolSize(Math.max(poolProperties.getMaxSize(), poolProperties.getCoreSize()));
        setQueueCapacity(poolProperties.getQueueSize());
    }

    @Override
    protected ExecutorService initializeExecutor(
            ThreadFactory threadFactory, RejectedExecutionHandler rejectedExecutionHandler) {
        return super.initializeExecutor(threadFactory, rejectedExecutionHandler);
    }

    @Override
    public List<Runnable> shutdownNow() {
        return getThreadPoolExecutor().shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return getThreadPoolExecutor().isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return getThreadPoolExecutor().isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return getThreadPoolExecutor().awaitTermination(timeout, unit);
    }


    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return getThreadPoolExecutor().submit(task, result);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return getThreadPoolExecutor().invokeAll(tasks);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return getThreadPoolExecutor().invokeAll(tasks, timeout, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return getThreadPoolExecutor().invokeAny(tasks);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return getThreadPoolExecutor().invokeAny(tasks, timeout, unit);
    }
    @Override
    public boolean isAutoStartup() {
        return true;
    }

    @Override
    public void start() {
        //do nothing
    }

    @Override
    public void stop() {
        //will not be invoked
    }

    @Override
    public boolean isRunning() {
        return !getThreadPoolExecutor().isTerminating() && !getThreadPoolExecutor().isTerminated();
    }

    //让GracefulCloseLifeCycle先stop
    @Override
    public int getPhase() {
        return -2;
    }

    public String getThreadPoolName() {
        return getThreadNamePrefix();
    }

    protected ThreadPoolExecutor getInnerThreadPoolExecutor(){
        return getThreadPoolExecutor();
    }

    @Override
    public void destroy() {
        //这里不销毁，使用SmartLifeCycle的机制来销毁
    }
}
