/*
 * Decompiled with CFR 0.152.
 */
package cn.lili.common.lock;

import cn.lili.common.lock.LockCallback;
import java.util.concurrent.TimeUnit;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DistributedLock {
    private static final Logger log = LoggerFactory.getLogger(DistributedLock.class);
    @Autowired
    private RedissonClient redissonClient;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(String lockName, Runnable runnable, Long waitTime, Long keepTime) {
        RLock lock = this.redissonClient.getLock(lockName);
        try {
            boolean isLocked = lock.tryLock(waitTime.longValue(), keepTime.longValue(), TimeUnit.SECONDS);
            if (isLocked) {
                runnable.run();
            } else {
                log.error("\u83b7\u53d6\u9501\u5931\u8d25... {}", (Object)lockName);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            lock.unlock();
        }
    }

    public void execute(String lockName, Runnable runnable) {
        this.execute(lockName, runnable, 10L, 5L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T executeWithResult(String lockName, LockCallback<T> callback, Long waitTime, Long keepTime) {
        RLock lock = this.redissonClient.getLock(lockName);
        try {
            boolean isLocked = lock.tryLock(waitTime.longValue(), keepTime.longValue(), TimeUnit.SECONDS);
            if (isLocked) {
                T t = callback.execute();
                return t;
            }
            log.error("\u83b7\u53d6\u9501\u5931\u8d25... {}", (Object)lockName);
            T t = null;
            return t;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            T t = null;
            return t;
        }
        finally {
            lock.unlock();
        }
    }

    public <T> T executeWithResult(String lockName, LockCallback<T> callback) {
        return this.executeWithResult(lockName, callback, 10L, 5L);
    }
}

