/*
 * Decompiled with CFR 0.152.
 */
package cn.lili.common.threadpool.properties;

import cn.lili.common.threadpool.properties.ThreadPoolProperties;
import com.google.common.collect.Maps;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@ConfigurationProperties(prefix="duiba.threadpool")
@Component
public class ThreadPoolConfig
extends ThreadPoolProperties {
    public static final Integer THREAD_MAX_SIZE = 2000;
    private Boolean enabled = false;
    private Map<String, ThreadPoolProperties> extra = Maps.newHashMap();

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public Map<String, ThreadPoolProperties> getExtra() {
        return this.extra;
    }

    public void setExtra(Map<String, ThreadPoolProperties> extra) {
        this.extra = extra;
    }

    public ThreadPoolProperties getDefaultThreadPoolProperties() {
        if (this.extra.containsKey("executorService")) {
            return this.extra.get("executorService");
        }
        ThreadPoolProperties properties = new ThreadPoolProperties();
        BeanUtils.copyProperties((Object)this, (Object)properties);
        return properties;
    }

    public Integer getMaxSizeCount() {
        Integer count = 0;
        for (ThreadPoolProperties poolProperties : this.extra.values()) {
            count = count + poolProperties.getMaxSize();
        }
        if (!this.extra.containsKey("executorService")) {
            count = count + this.getMaxSize();
        }
        return count;
    }
}

