/*
 * Decompiled with CFR 0.152.
 */
package cn.lili.common.utils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;

public final class CurrencyUtil {
    private static final int DEF_DIV_SCALE = 2;

    private CurrencyUtil() {
    }

    public static Double add(double ... params) {
        BigDecimal result = new BigDecimal("0");
        for (double param : params) {
            BigDecimal bigParam = BigDecimal.valueOf(param);
            result = result.add(bigParam).setScale(2, RoundingMode.HALF_UP);
        }
        return result.doubleValue();
    }

    public static Double sub(double ... params) {
        BigDecimal result = BigDecimal.valueOf(params[0]);
        for (double param : params = Arrays.stream(params).skip(1L).toArray()) {
            BigDecimal bigParam = BigDecimal.valueOf(param);
            result = result.subtract(bigParam).setScale(2, RoundingMode.HALF_UP);
        }
        return result.doubleValue();
    }

    public static Double mul(double v1, double v2) {
        BigDecimal b1 = BigDecimal.valueOf(v1);
        BigDecimal b2 = BigDecimal.valueOf(v2);
        return b1.multiply(b2).setScale(2, RoundingMode.HALF_UP).doubleValue();
    }

    public static Double mul(double v1, double v2, int scale) {
        if (scale < 0) {
            throw new IllegalArgumentException("The scale must be a positive integer or zero");
        }
        BigDecimal b1 = BigDecimal.valueOf(v1);
        BigDecimal b2 = BigDecimal.valueOf(v2);
        return b1.multiply(b2).setScale(scale, RoundingMode.HALF_UP).doubleValue();
    }

    public static double div(double v1, double v2) {
        return CurrencyUtil.div(v1, v2, 2);
    }

    public static double div(double v1, double v2, int scale) {
        if (scale < 0) {
            throw new IllegalArgumentException("The scale must be a positive integer or zero");
        }
        if (v2 == 0.0) {
            return 0.0;
        }
        BigDecimal b1 = BigDecimal.valueOf(v1);
        BigDecimal b2 = BigDecimal.valueOf(v2);
        return b1.divide(b2, scale, RoundingMode.HALF_UP).doubleValue();
    }

    public static Integer fen(Double money) {
        double price = CurrencyUtil.mul(money, 100.0);
        return (int)price;
    }

    public static double reversalFen(Double money) {
        return CurrencyUtil.div(money, 100.0);
    }

    public static double reversalFen(int money) {
        return CurrencyUtil.div(money, 100.0);
    }
}

