/*
 * Decompiled with CFR 0.152.
 */
package cn.lili.common.utils;

import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;

@Configuration
public class RestTemplateUtil {
    @Value(value="${restTemplate.maxTotalConnect:100}")
    private Integer maxTotalConnect;
    @Value(value="${restTemplate.maxConnectPerRoute:100}")
    private Integer maxConnectPerRoute;
    @Value(value="${restTemplate.connectTimeout:3000}")
    private Integer connectTimeout;
    @Value(value="${restTemplate.readTimeout:5000}")
    private Integer readTimeout;
    @Value(value="${restTemplate.connectionRequestTimeout:3000}")
    private Integer connectionRequestTimeout;

    @Bean
    public ClientHttpRequestFactory clientHttpRequestFactory() {
        if (this.maxTotalConnect <= 0) {
            SimpleClientHttpRequestFactory factory = new SimpleClientHttpRequestFactory();
            factory.setConnectTimeout(this.connectTimeout.intValue());
            factory.setReadTimeout(this.readTimeout.intValue());
            return factory;
        }
        RequestConfig globalConfig = RequestConfig.custom().setCookieSpec("ignoreCookies").build();
        CloseableHttpClient httpClient = HttpClientBuilder.create().setMaxConnTotal(this.maxTotalConnect.intValue()).setMaxConnPerRoute(this.maxConnectPerRoute.intValue()).setDefaultRequestConfig(globalConfig).build();
        HttpComponentsClientHttpRequestFactory factory = new HttpComponentsClientHttpRequestFactory((HttpClient)httpClient);
        factory.setConnectTimeout(this.connectTimeout.intValue());
        factory.setReadTimeout(this.readTimeout.intValue());
        factory.setConnectionRequestTimeout(this.connectionRequestTimeout.intValue());
        return factory;
    }

    @Bean
    public RestTemplate restTemplate(@Qualifier(value="clientHttpRequestFactory") ClientHttpRequestFactory factory) {
        return new RestTemplate(factory);
    }
}

