package cn.lili.rocketmq;

import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import org.apache.rocketmq.client.producer.SendCallback;
import org.apache.rocketmq.client.producer.SendResult;

/**
 * @author paulG
 * @since 2020/11/4
 **/
@Slf4j
@Data
public class RocketmqSendCallback implements SendCallback {

    private String topic;

    private String tag;

    private String message;

    @Override
    public void onSuccess(SendResult sendResult) {
        log.info("async onSuccess topic:{}, tag:{}, message:{}, messageId:{}", topic, tag, message, sendResult.getMsgId());
    }

    @Override
    public void onException(Throwable throwable) {
        log.error("async onException topic:{}, tag:{}, message:{}", topic, tag, message, throwable);
    }
}
