/*
 * Decompiled with CFR 0.152.
 */
package cn.lili.rocketmq.consumer;

import cn.lili.rocketmq.consumer.annotation.TagSub;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMessageHandler {
    private static final Logger log = LoggerFactory.getLogger(AbstractMessageHandler.class);

    public void consumer(String message, int reConsumerTimes, String topic, String tag) throws Exception {
        try {
            this.doConsumer(message);
        }
        catch (Exception e) {
            if (this.needReConsumer(reConsumerTimes)) {
                throw e;
            }
            log.error("AbstractMessageHandler consumer error topic:{}, tag:{}, message:{}, handlerName:{}", new Object[]{topic, tag, message, this.getTagName()});
        }
    }

    protected abstract void doConsumer(String var1);

    protected boolean needReConsumer(int reConsumerTimes) {
        return true;
    }

    public String getTagName() {
        return this.getClass().getDeclaredAnnotation(TagSub.class).tag();
    }
}

