/*
 * Decompiled with CFR 0.152.
 */
package cn.lili.rocketmq.consumer;

import cn.lili.rocketmq.consumer.AbstractMessageHandler;
import cn.lili.rocketmq.consumer.MessageHandlerInstanceHandler;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.apache.rocketmq.common.message.MessageExt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ConsumerMessageService {
    private static final Logger log = LoggerFactory.getLogger(ConsumerMessageService.class);

    public void consumer(MessageExt messageExt) throws Exception {
        String topic = messageExt.getTopic();
        String tags = messageExt.getTags();
        String message = new String(messageExt.getBody(), StandardCharsets.UTF_8);
        log.info("ConsumerMessageService consumer topic:{}, tag:{}, message:{}", new Object[]{topic, tags, message});
        AbstractMessageHandler consumer = MessageHandlerInstanceHandler.getInstance(tags);
        if (Objects.isNull(consumer)) {
            log.info("ConsumerMessageService consumer \u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u6d88\u8d39\u8005 topic:{}, tag:{}, message:{}", new Object[]{topic, tags, message});
            return;
        }
        consumer.consumer(message, messageExt.getReconsumeTimes(), topic, tags);
    }
}

