/*
 * Decompiled with CFR 0.152.
 */
package cn.lili.rocketmq.consumer.listner;

import cn.lili.rocketmq.consumer.AbstractMessageHandler;
import cn.lili.rocketmq.consumer.MessageHandlerInstanceHandler;
import cn.lili.rocketmq.consumer.annotation.TagSub;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Component;

@Component
public class InitRocketMqMessageHandlerListener
implements ApplicationListener<ContextRefreshedEvent> {
    private static final Logger log = LoggerFactory.getLogger(InitRocketMqMessageHandlerListener.class);

    public void onApplicationEvent(ContextRefreshedEvent event) {
        Map beansWithAnnotation = event.getApplicationContext().getBeansWithAnnotation(TagSub.class);
        if (beansWithAnnotation != null && !beansWithAnnotation.isEmpty()) {
            beansWithAnnotation.values().forEach(bean -> {
                if (bean instanceof AbstractMessageHandler) {
                    TagSub declaredAnnotation = bean.getClass().getDeclaredAnnotation(TagSub.class);
                    String tag = declaredAnnotation.tag();
                    log.info("\u521d\u59cb\u5316 tag\u5bf9\u5e94\u7684handler tag:{}", (Object)tag);
                    MessageHandlerInstanceHandler.abstractMessageHandlerMap.put(tag, (AbstractMessageHandler)bean);
                }
            });
        }
    }
}

