/*
 * Decompiled with CFR 0.152.
 */
package cn.lili.rocketmq.send;

import cn.lili.common.enums.ResultCode;
import cn.lili.common.exception.ServiceException;
import cn.lili.common.utils.StringUtils;
import cn.lili.rocketmq.RocketmqSendCallback;
import cn.lili.rocketmq.RocketmqSendCallbackBuilder;
import com.alibaba.fastjson.JSON;
import org.apache.rocketmq.client.producer.SendCallback;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.spring.core.RocketMQTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RocketmqProduce {
    private static final Logger log = LoggerFactory.getLogger(RocketmqProduce.class);
    private static final String COLON = ":";
    @Autowired
    private RocketMQTemplate rocketMQTemplate;

    public void sendMessageSync(String topic, String tag, String message) {
        if (StringUtils.isBlank((CharSequence)topic) || StringUtils.isBlank((CharSequence)tag)) {
            throw new ServiceException(ResultCode.PARAMS_ERROR);
        }
        String destination = topic + COLON + tag;
        try {
            SendResult sendResult = this.rocketMQTemplate.syncSend(destination, (Object)message);
            log.info("sendMessageSync topic:{},tag:{}, message:{}, result:{}", new Object[]{topic, tag, message, JSON.toJSON((Object)sendResult)});
        }
        catch (Exception e) {
            log.error("sendMessageSync topic:{}, tag:{}, message:{}, e", new Object[]{topic, tag, message, e});
        }
    }

    public void sendMessageSyncWithTimeout(String topic, String tag, String message, long timeout) {
        if (StringUtils.isBlank((CharSequence)topic) || StringUtils.isBlank((CharSequence)tag)) {
            throw new ServiceException(ResultCode.PARAMS_ERROR);
        }
        String destination = topic + COLON + tag;
        try {
            SendResult sendResult = this.rocketMQTemplate.syncSend(destination, (Object)message, timeout);
            log.info("sendMessageSyncWithTimeout topic:{},tag:{}, message:{}, result:{}", new Object[]{topic, tag, message, JSON.toJSON((Object)sendResult)});
        }
        catch (Exception e) {
            log.error("sendMessageSyncWithTimeout topic:{}, tag:{}, message:{}, e", new Object[]{topic, tag, message, e});
        }
    }

    public void sendMessageAsync(String topic, String tag, String message) {
        if (StringUtils.isBlank((CharSequence)topic) || StringUtils.isBlank((CharSequence)tag)) {
            throw new ServiceException(ResultCode.PARAMS_ERROR);
        }
        String destination = topic + COLON + tag;
        try {
            RocketmqSendCallback rocketmqSendCallback = RocketmqSendCallbackBuilder.commonCallback();
            rocketmqSendCallback.setTopic(topic);
            rocketmqSendCallback.setTag(tag);
            rocketmqSendCallback.setMessage(message);
            this.rocketMQTemplate.asyncSend(destination, (Object)message, (SendCallback)rocketmqSendCallback);
            log.info("sendMessageAsync topic:{},tag:{}, message:{}, result:{}", new Object[]{topic, tag, message});
        }
        catch (Exception e) {
            log.error("sendMessageAsync topic:{}, tag:{}, message:{}, e", new Object[]{topic, tag, message, e});
        }
    }

    public void sendMessageAsyncWithTimeout(String topic, String tag, String message, SendCallback sendCallback, long timeout) {
        if (StringUtils.isBlank((CharSequence)topic) || StringUtils.isBlank((CharSequence)tag)) {
            throw new ServiceException(ResultCode.PARAMS_ERROR);
        }
        String destination = topic + COLON + tag;
        try {
            this.rocketMQTemplate.asyncSend(destination, (Object)message, sendCallback, timeout);
            log.info("sendMessageAsyncWithTimeout topic:{},tag:{}, message:{}, result:{}", new Object[]{topic, tag, message});
        }
        catch (Exception e) {
            log.error("sendMessageAsyncWithTimeout topic:{}, tag:{}, message:{}, e", new Object[]{topic, tag, message, e});
        }
    }
}

