/*
 * Decompiled with CFR 0.152.
 */
package cn.lili.trigger.interfaces.impl;

import cn.hutool.json.JSONUtil;
import cn.lili.cache.Cache;
import cn.lili.common.utils.DateUtil;
import cn.lili.common.utils.StringUtils;
import cn.lili.rocketmq.RocketmqSendCallbackBuilder;
import cn.lili.trigger.delay.queue.PromotionDelayQueue;
import cn.lili.trigger.interfaces.TimeTrigger;
import cn.lili.trigger.model.TimeTriggerMsg;
import cn.lili.trigger.util.DelayQueueTools;
import org.apache.rocketmq.client.producer.SendCallback;
import org.apache.rocketmq.spring.core.RocketMQTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.Message;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.stereotype.Component;

@Component
public class RocketmqTimerTrigger
implements TimeTrigger {
    private static final Logger log = LoggerFactory.getLogger(RocketmqTimerTrigger.class);
    @Autowired
    private RocketMQTemplate rocketMQTemplate;
    @Autowired
    private Cache<Integer> cache;
    @Autowired
    private PromotionDelayQueue promotionDelayQueue;

    @Override
    public void addDelay(TimeTriggerMsg timeTriggerMsg) {
        String uniqueKey = timeTriggerMsg.getUniqueKey();
        if (StringUtils.isEmpty((CharSequence)uniqueKey)) {
            uniqueKey = StringUtils.getRandStr((int)10);
        }
        String generateKey = DelayQueueTools.generateKey(timeTriggerMsg.getTriggerExecutor(), timeTriggerMsg.getTriggerTime(), uniqueKey);
        this.cache.put((Object)generateKey, (Object)1);
        if (Boolean.TRUE.equals(this.promotionDelayQueue.addJob(JSONUtil.toJsonStr((Object)timeTriggerMsg), timeTriggerMsg.getTriggerTime()))) {
            log.info("\u5ef6\u65f6\u4efb\u52a1\u6807\u8bc6\uff1a {}", (Object)generateKey);
            log.info("\u5b9a\u65f6\u6267\u884c\u5728\u3010" + DateUtil.toString((Long)timeTriggerMsg.getTriggerTime(), (String)"yyyy-MM-dd HH:mm:ss") + "\u3011\uff0c\u6d88\u8d39\u3010" + timeTriggerMsg.getParam().toString() + "\u3011");
        } else {
            log.error("\u5ef6\u65f6\u4efb\u52a1\u6dfb\u52a0\u5931\u8d25:{}", (Object)timeTriggerMsg);
        }
    }

    @Override
    public void execute(TimeTriggerMsg timeTriggerMsg) {
        this.addExecute(timeTriggerMsg.getTriggerExecutor(), timeTriggerMsg.getParam(), timeTriggerMsg.getTriggerTime(), timeTriggerMsg.getUniqueKey(), timeTriggerMsg.getTopic());
    }

    private void addExecute(String executorName, Object param, Long triggerTime, String uniqueKey, String topic) {
        TimeTriggerMsg timeTriggerMsg = new TimeTriggerMsg(executorName, triggerTime, param, uniqueKey, topic);
        Message message = MessageBuilder.withPayload((Object)timeTriggerMsg).build();
        log.info("\u5ef6\u65f6\u4efb\u52a1\u53d1\u9001\u4fe1\u606f\uff1a{}", (Object)message);
        this.rocketMQTemplate.asyncSend(topic, message, (SendCallback)RocketmqSendCallbackBuilder.commonCallback());
    }

    @Override
    public void edit(String executorName, Object param, Long oldTriggerTime, Long triggerTime, String uniqueKey, int delayTime, String topic) {
        this.delete(executorName, oldTriggerTime, uniqueKey, topic);
        this.addDelay(new TimeTriggerMsg(executorName, triggerTime, param, uniqueKey, topic));
    }

    @Override
    public void delete(String executorName, Long triggerTime, String uniqueKey, String topic) {
        String generateKey = DelayQueueTools.generateKey(executorName, triggerTime, uniqueKey);
        log.info("\u5220\u9664\u5ef6\u65f6\u4efb\u52a1{}", (Object)generateKey);
        this.cache.remove((Object)generateKey);
    }
}

