/*
 * Decompiled with CFR 0.152.
 */
package open.api.sdk.cipher.jwt;

import io.jsonwebtoken.MalformedJwtException;
import io.jsonwebtoken.impl.io.InstanceLocator;
import io.jsonwebtoken.io.Decoder;
import io.jsonwebtoken.io.Decoders;
import io.jsonwebtoken.io.Encoder;
import io.jsonwebtoken.io.Encoders;
import io.jsonwebtoken.io.SerializationException;
import io.jsonwebtoken.io.Serializer;
import io.jsonwebtoken.lang.Assert;
import io.jsonwebtoken.lang.Classes;
import io.jsonwebtoken.lang.Strings;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import open.api.sdk.cipher.exception.JWTException;
import open.api.sdk.cipher.jwe.AAD;
import open.api.sdk.cipher.sm2.SM2Util;
import open.api.sdk.cipher.sm3.SM3Util;
import open.api.sdk.cipher.sm4.SM4Util;
import open.api.sdk.cipher.utils.Util;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.pqc.math.linearalgebra.ByteUtils;

public class JWT {
    public static String signJWS(String kid, String privateKeyStr, String plainText) throws IOException, CryptoException {
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("alg", "SM2");
        header.put("typ", "JWT");
        header.put("kid", kid);
        Encoder base64UrlEncoder = Encoders.BASE64URL;
        String base64UrlEncodedHeader = JWT.base64UrlEncode(header, "Unable to serialize header to json.", (Encoder<byte[], String>)base64UrlEncoder);
        String base64UrlEncodedBody = "";
        String base64UrlSignature = "";
        HashMap claims = new HashMap();
        byte[] bytes = JWT.toJson(claims);
        base64UrlEncodedBody = (String)base64UrlEncoder.encode((Object)bytes);
        String jwt = String.valueOf(base64UrlEncodedHeader) + '.' + base64UrlEncodedBody;
        base64UrlSignature = plainText == null || plainText.equals("") ? (String)base64UrlEncoder.encode((Object)SM2Util.sign(jwt, privateKeyStr)) : (String)base64UrlEncoder.encode((Object)SM2Util.sign(String.valueOf(base64UrlEncodedHeader) + '.' + plainText, privateKeyStr));
        jwt = String.valueOf(jwt) + '.' + base64UrlSignature;
        return jwt;
    }

    public static boolean checkJWS(String jwt, String publicKeyStr, String plainText) throws JWTException {
        Decoder base64UrlDecoder = Decoders.BASE64URL;
        boolean flag = false;
        StringBuilder sb = new StringBuilder(128);
        int delimiterCount = 0;
        String base64UrlEncodedHeader = null;
        String base64UrlEncodedBody = null;
        String base64UrlSignature = null;
        String M = null;
        char[] cArray = jwt.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c == '.') {
                String token;
                CharSequence tokenSeq = Strings.clean((CharSequence)sb);
                String string = token = tokenSeq != null ? tokenSeq.toString() : null;
                if (delimiterCount == 0) {
                    base64UrlEncodedHeader = token;
                } else if (delimiterCount == 1) {
                    base64UrlEncodedBody = token;
                }
                ++delimiterCount;
                sb.setLength(0);
            } else {
                sb.append(c);
            }
            ++n2;
        }
        if (delimiterCount != 2) {
            String msg = "JWT strings must contain exactly 2 period characters. Found: " + delimiterCount;
            throw new MalformedJwtException(msg);
        }
        if (sb.length() > 0) {
            base64UrlSignature = sb.toString();
        }
        if (base64UrlEncodedHeader == null) {
            throw new MalformedJwtException("JWT string '" + jwt + "' is missing a header.");
        }
        if (base64UrlEncodedBody == null) {
            throw new MalformedJwtException("JWT string '" + jwt + "' is missing a playload.");
        }
        if (base64UrlSignature == null) {
            throw new MalformedJwtException("JWT string '" + jwt + "' is missing a signature.");
        }
        try {
            M = plainText != null && !plainText.equals("") ? String.valueOf(base64UrlEncodedHeader) + '.' + plainText : String.valueOf(base64UrlEncodedHeader) + '.' + base64UrlEncodedBody;
            flag = SM2Util.checkSign(M, (byte[])base64UrlDecoder.decode((Object)base64UrlSignature), publicKeyStr);
        }
        catch (IOException e) {
            throw new JWTException("fail to check JWS", e);
        }
        return flag;
    }

    public static String signJWE(String appId, String publicKeyStr, String plainText) throws IOException, NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException, InvalidAlgorithmParameterException, InvalidKeyException, InvalidCipherTextException {
        Encoder base64UrlEncoder = Encoders.BASE64URL;
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("alg", "SM2");
        header.put("typ", "JWT");
        header.put("kid", appId);
        header.put("enc", "SM4");
        String base64UrlEncodedHeader = JWT.base64UrlEncode(header, "Unable to serialize header to json.", (Encoder<byte[], String>)base64UrlEncoder);
        String sm4EncKey = Util.byteToHex(SM4Util.generateKey());
        String hmacKey = Util.byteToHex(SM4Util.generateKey());
        String base64EncryptedKey = (String)base64UrlEncoder.encode((Object)Util.byteToHex(SM2Util.encrypt(String.valueOf(hmacKey) + sm4EncKey, publicKeyStr)).getBytes());
        String iv = Util.byteToHex(SM4Util.generateSM4IV(128));
        String base64Iv = (String)base64UrlEncoder.encode((Object)iv.getBytes());
        byte[] cipherTextByte = SM4Util.encrypt_Cbc_Padding(Util.hexStringToBytes(sm4EncKey), Util.hexStringToBytes(iv), plainText.getBytes("UTF-8"));
        String cipherText = Util.byteToHex(cipherTextByte);
        String base64Ciphertext = (String)base64UrlEncoder.encode((Object)cipherText.getBytes());
        byte[] aadBytes = AAD.compute(base64UrlEncodedHeader);
        byte[] alBytes = AAD.computeLength(aadBytes);
        byte[] concatBytes = Util.concatenate(aadBytes, Util.hexToByte(iv), Util.hexToByte(cipherText), alBytes);
        byte[] hmacBytes = SM3Util.sm3DigistAsBytes(concatBytes);
        byte[] tagBytes = ByteUtils.subArray((byte[])hmacBytes, (int)0, (int)16);
        String base64Tag = (String)base64UrlEncoder.encode((Object)tagBytes);
        String jwe = String.valueOf(base64UrlEncodedHeader) + '.' + base64EncryptedKey + '.' + base64Iv + '.' + base64Ciphertext + '.' + base64Tag;
        return jwe;
    }

    public static String decryptJWE(String jwe, String privateKeyStr) throws IOException, InvalidCipherTextException, BadPaddingException, NoSuchPaddingException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, IllegalBlockSizeException, NoSuchProviderException, InvalidKeyException {
        StringBuilder sb = new StringBuilder(128);
        int delimiterCount = 0;
        String base64UrlEncodedHeader = null;
        String base64EncryptedKey = null;
        String base64Iv = null;
        String base64Ciphertext = null;
        String base64Tag = null;
        char[] cArray = jwe.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c == '.') {
                String token;
                CharSequence tokenSeq = Strings.clean((CharSequence)sb);
                String string = token = tokenSeq != null ? tokenSeq.toString() : null;
                if (delimiterCount == 0) {
                    base64UrlEncodedHeader = token;
                } else if (delimiterCount == 1) {
                    base64EncryptedKey = token;
                } else if (delimiterCount == 2) {
                    base64Iv = token;
                } else if (delimiterCount == 3) {
                    base64Ciphertext = token;
                }
                ++delimiterCount;
                sb.setLength(0);
            } else {
                sb.append(c);
            }
            ++n2;
        }
        if (delimiterCount != 4) {
            String msg = "JWE strings must contain exactly 4 period characters. Found: " + delimiterCount;
            throw new MalformedJwtException(msg);
        }
        if (sb.length() > 0) {
            base64Tag = sb.toString();
        }
        if (base64UrlEncodedHeader == null) {
            throw new MalformedJwtException("JWE string '" + jwe + "' is missing a header.");
        }
        if (base64EncryptedKey == null) {
            throw new MalformedJwtException("JWE string '" + jwe + "' is missing a encryptedKey.");
        }
        if (base64Iv == null) {
            throw new MalformedJwtException("JWE string '" + jwe + "' is missing a iv.");
        }
        if (base64Ciphertext == null) {
            throw new MalformedJwtException("JWE string '" + jwe + "' is missing a ciphertext.");
        }
        if (base64Tag == null) {
            throw new MalformedJwtException("JWE string '" + jwe + "' is missing a tag.");
        }
        Decoder base64UrlDecoder = Decoders.BASE64URL;
        Encoder base64UrlEncoder = Encoders.BASE64URL;
        byte[] encryptedKeyByte = (byte[])base64UrlDecoder.decode((Object)base64EncryptedKey);
        byte[] encryptedKeyByte2 = Util.hexToByte(new String(encryptedKeyByte));
        String encryptedKey = new String(encryptedKeyByte2, "utf-8");
        String secretKey = new String(SM2Util.decrypt(encryptedKeyByte2, privateKeyStr));
        byte[] cekBytes = Util.hexToByte(secretKey);
        if (cekBytes.length != 32) {
            throw new MalformedJwtException("JWE string's encryption key must contain exactly 256 bits.");
        }
        String hmacKey = Util.byteToHex(ByteUtils.subArray((byte[])cekBytes, (int)0, (int)16));
        String sm4EncKey = Util.byteToHex(ByteUtils.subArray((byte[])cekBytes, (int)16));
        String iv = new String((byte[])base64UrlDecoder.decode((Object)base64Iv));
        String cipherText = new String((byte[])base64UrlDecoder.decode((Object)base64Ciphertext));
        byte[] aadBytes = AAD.compute(base64UrlEncodedHeader);
        byte[] alBytes = AAD.computeLength(aadBytes);
        byte[] concatBytes = Util.concatenate(aadBytes, Util.hexToByte(iv), Util.hexToByte(cipherText), alBytes);
        byte[] hmacBytes = SM3Util.sm3DigistAsBytes(concatBytes);
        byte[] tagBytes = ByteUtils.subArray((byte[])hmacBytes, (int)0, (int)16);
        if (!((String)base64UrlEncoder.encode((Object)tagBytes)).equals(base64Tag)) {
            throw new MalformedJwtException("JWE tag '" + base64Tag + "' is error.");
        }
        byte[] plainTextByte = SM4Util.decrypt_Cbc_Padding(Util.hexStringToBytes(sm4EncKey), Util.hexStringToBytes(iv), Util.hexToByte(cipherText));
        String plainText = new String(plainTextByte, "UTF-8");
        return plainText;
    }

    protected static String base64UrlEncode(Object o, String errMsg, Encoder<byte[], String> base64UrlEncoder) {
        byte[] bytes;
        Assert.isInstanceOf(Map.class, (Object)o, (String)"object argument must be a map.");
        Map m = (Map)o;
        try {
            bytes = JWT.toJson(m);
        }
        catch (SerializationException e) {
            throw new IllegalStateException(errMsg, e);
        }
        return (String)base64UrlEncoder.encode((Object)bytes);
    }

    protected static byte[] toJson(Object object) throws SerializationException {
        Assert.isInstanceOf(Map.class, (Object)object, (String)"object argument must be a map.");
        Map m = (Map)object;
        InstanceLocator locator = (InstanceLocator)Classes.newInstance((String)"io.jsonwebtoken.impl.io.RuntimeClasspathSerializerLocator");
        Serializer serializer = (Serializer)locator.getInstance();
        return serializer.serialize((Object)m);
    }
}

