/*
 * Decompiled with CFR 0.152.
 */
package open.api.sdk.cipher.sm2;

import java.io.IOException;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.gm.GMNamedCurves;
import org.bouncycastle.asn1.gm.GMObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.sec.ECPrivateKey;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.asn1.x9.X9ECPoint;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.digests.SM3Digest;
import org.bouncycastle.crypto.engines.SM2Engine;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.crypto.signers.SM2Signer;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.util.encoders.Base64;

public class SM2Util {
    public static byte[] sign(String oriData, String p8) throws IOException, CryptoException {
        ASN1Primitive asn1Primitive = new ASN1InputStream(Base64.decode((byte[])p8.getBytes())).readObject();
        PrivateKeyInfo privateKeyInfo = PrivateKeyInfo.getInstance((Object)asn1Primitive);
        ECPrivateKeyParameters ecPrivateKeyParameters = SM2Util.parseEcPrivateKey(privateKeyInfo);
        SM2Signer signer = new SM2Signer();
        signer.init(true, (CipherParameters)ecPrivateKeyParameters);
        byte[] oriDataByte = oriData.getBytes();
        signer.update(oriDataByte, 0, oriDataByte.length);
        return Base64.encode((byte[])signer.generateSignature());
    }

    public static boolean checkSign(String oriData, byte[] signData, String b64Cert) throws IOException {
        X509CertificateHolder certHolder = new X509CertificateHolder(Base64.decode((String)b64Cert));
        ECPublicKeyParameters pubKeyParameters = SM2Util.parseEcPublicKey(certHolder);
        SM2Signer signer = new SM2Signer();
        signer.init(false, (CipherParameters)pubKeyParameters);
        byte[] oriDataByte = oriData.getBytes();
        signer.update(oriDataByte, 0, oriDataByte.length);
        return signer.verifySignature(Base64.decode((byte[])signData));
    }

    public static byte[] encrypt(String oriData, String b64Cert) throws InvalidCipherTextException, IOException {
        X509CertificateHolder certHolder = new X509CertificateHolder(Base64.decode((String)b64Cert));
        ParametersWithRandom pubKeyParameters = new ParametersWithRandom((CipherParameters)SM2Util.parseEcPublicKey(certHolder), new SecureRandom());
        SM2Engine sm2Engine = new SM2Engine((Digest)new SM3Digest(), SM2Engine.Mode.C1C3C2);
        sm2Engine.init(true, (CipherParameters)pubKeyParameters);
        byte[] oriDataByte = oriData.getBytes();
        return sm2Engine.processBlock(oriDataByte, 0, oriDataByte.length);
    }

    public static byte[] decrypt(byte[] encData, String p8) throws IOException, InvalidCipherTextException {
        ASN1Primitive asn1Primitive = new ASN1InputStream(Base64.decode((byte[])p8.getBytes())).readObject();
        PrivateKeyInfo privateKeyInfo = PrivateKeyInfo.getInstance((Object)asn1Primitive);
        ECPrivateKeyParameters ecPrivateKeyParameters = SM2Util.parseEcPrivateKey(privateKeyInfo);
        SM2Engine sm2Engine = new SM2Engine((Digest)new SM3Digest(), SM2Engine.Mode.C1C3C2);
        sm2Engine.init(false, (CipherParameters)ecPrivateKeyParameters);
        return sm2Engine.processBlock(encData, 0, encData.length);
    }

    public static byte[] decrypt(String encData, String p8) throws IOException, InvalidCipherTextException {
        ASN1Primitive asn1Primitive = new ASN1InputStream(Base64.decode((byte[])p8.getBytes())).readObject();
        PrivateKeyInfo privateKeyInfo = PrivateKeyInfo.getInstance((Object)asn1Primitive);
        ECPrivateKeyParameters ecPrivateKeyParameters = SM2Util.parseEcPrivateKey(privateKeyInfo);
        SM2Engine sm2Engine = new SM2Engine((Digest)new SM3Digest(), SM2Engine.Mode.C1C3C2);
        sm2Engine.init(false, (CipherParameters)ecPrivateKeyParameters);
        byte[] encDataByte = encData.getBytes(StandardCharsets.UTF_8);
        return sm2Engine.processBlock(encDataByte, 0, encDataByte.length);
    }

    private static ECPublicKeyParameters parseEcPublicKey(X509CertificateHolder cert) {
        SubjectPublicKeyInfo keyInfo = cert.getSubjectPublicKeyInfo();
        byte[] pubKeyData = keyInfo.getPublicKeyData().getBytes();
        X9ECParameters gmParams = GMNamedCurves.getByOID((ASN1ObjectIdentifier)GMObjectIdentifiers.sm2p256v1);
        ECDomainParameters gmDomainParams = new ECDomainParameters(gmParams.getCurve(), gmParams.getG(), gmParams.getN(), gmParams.getH(), gmParams.getSeed());
        X9ECPoint x9Point = new X9ECPoint(gmParams.getCurve(), pubKeyData);
        ECPoint pubKeyPoint = x9Point.getPoint();
        return new ECPublicKeyParameters(pubKeyPoint, gmDomainParams);
    }

    private static ECPrivateKeyParameters parseEcPrivateKey(PrivateKeyInfo privKeyInfo) {
        ECPrivateKey ec = null;
        try {
            ec = ECPrivateKey.getInstance((Object)privKeyInfo.parsePrivateKey());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        BigInteger d = ec.getKey();
        X9ECParameters gmParams = GMNamedCurves.getByOID((ASN1ObjectIdentifier)GMObjectIdentifiers.sm2p256v1);
        ECDomainParameters gmDomainParams = new ECDomainParameters(gmParams.getCurve(), gmParams.getG(), gmParams.getN(), gmParams.getH(), gmParams.getSeed());
        return new ECPrivateKeyParameters(d, gmDomainParams);
    }
}

