/*
 * Decompiled with CFR 0.152.
 */
package open.api.sdk.common;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import open.api.sdk.entity.BaseResponse;

public class JsonUtil {
    private static String SUCCESS_CODE = "000000";

    public static <T> BaseResponse<T> build(String str) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode jsonNode = mapper.readTree(str);
            JsonNode jsonData = jsonNode.get("Code");
            if (jsonData != null) {
                String code = jsonData.asText();
                if (!code.equals(SUCCESS_CODE)) {
                    BaseResponse response = new BaseResponse();
                    response.setCode(code);
                    jsonData = jsonNode.get("Message");
                    if (jsonData != null) {
                        response.setMessage(jsonData.toString());
                    }
                    return response;
                }
            } else {
                String code;
                jsonData = jsonNode.get("code");
                if (jsonData != null && !(code = jsonData.asText()).equals(SUCCESS_CODE)) {
                    BaseResponse response = new BaseResponse();
                    response.setCode(code);
                    jsonData = jsonNode.get("message");
                    if (jsonData != null) {
                        response.setMessage(jsonData.toString());
                    }
                    return response;
                }
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }
}

