/*
 * Decompiled with CFR 0.152.
 */
package open.api.sdk.common;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public class StringUtil {
    private static ObjectMapper objectMapper = new ObjectMapper();

    public static String map2Form(Map<String, String> map) {
        if (map == null || map.size() == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (map == null) {
            return stringBuilder.toString();
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            stringBuilder.append(entry.getKey()).append("=").append(entry.getValue()).append("&");
        }
        return stringBuilder.substring(0, stringBuilder.length() - 1);
    }

    public static Map<String, Object> readJsonObject(String jsonString) throws IOException {
        return (Map)objectMapper.readValue(jsonString, (TypeReference)new TypeReference<LinkedHashMap<String, Object>>(){});
    }

    public static <T> T readJsonObject(String jsonString, Class<T> clazz) throws IOException {
        return (T)objectMapper.readValue(jsonString, clazz);
    }

    public static <T> T readJsonObject(String jsonString, TypeReference<T> typeReference) throws IOException {
        return (T)objectMapper.readValue(jsonString, typeReference);
    }

    public static String writeJsonObject(Object obj) throws IOException {
        return objectMapper.writeValueAsString(obj);
    }

    public static String writeObject(Object obj) throws IOException {
        return objectMapper.writeValueAsString(obj);
    }
}

