/*
 * Decompiled with CFR 0.152.
 */
package open.api.sdk.common.http;

import java.io.IOException;
import java.util.Map;
import open.api.sdk.common.http.Accept;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;

public class HttpUtil {
    public static HttpResponse post(HttpClient httpClient, String url, Map<String, String> headerMap, String body, boolean isEncrypt) throws IOException {
        return HttpUtil.post(httpClient, (HttpEntityEnclosingRequestBase)new HttpPost(url), headerMap, body, isEncrypt);
    }

    private static HttpResponse post(HttpClient httpClient, HttpEntityEnclosingRequestBase httpEntityEnclosingRequestBase, Map<String, String> headerMap, String body, boolean isEncrypt) throws IOException {
        HttpUtil.addHeaders(httpEntityEnclosingRequestBase, headerMap);
        if (body != null) {
            StringEntity stringEntity = null;
            if (!isEncrypt) {
                stringEntity = new StringEntity(body, ContentType.APPLICATION_JSON);
                stringEntity.setContentType(Accept.JSON.getTypeName());
            } else {
                stringEntity = new StringEntity(body);
                stringEntity.setContentType(Accept.TEXT.getTypeName());
            }
            stringEntity.setContentEncoding("UTF-8");
            httpEntityEnclosingRequestBase.setEntity((HttpEntity)stringEntity);
        }
        return httpClient.execute((HttpUriRequest)httpEntityEnclosingRequestBase);
    }

    private static <T extends HttpRequestBase> T addHeaders(T t, Map<String, String> headers) {
        for (Map.Entry<String, String> headerEntry : headers.entrySet()) {
            t.addHeader(headerEntry.getKey(), headerEntry.getValue());
        }
        return t;
    }
}

