/*
 * Decompiled with CFR 0.152.
 */
package open.api.sdk.wlb.service;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import open.api.sdk.wlb.entity.ServerInfo;
import open.api.sdk.wlb.service.ScanServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WlbServer {
    private static final Logger log = LoggerFactory.getLogger(WlbServer.class);
    private static volatile List<ServerInfo> serverInfoList = new ArrayList<ServerInfo>();
    private static ScanServer scanServer = null;
    private static ExecutorService executor = Executors.newCachedThreadPool();

    public static void init(List<ServerInfo> _serverInfoList) {
        serverInfoList = _serverInfoList;
        scanServer = new ScanServer(serverInfoList);
        executor.submit(scanServer);
    }

    public static ServerInfo getServerInfo() {
        double scale = Double.MAX_VALUE;
        double scaleTemp = 0.0;
        ServerInfo serverInfoTemp = null;
        for (ServerInfo serverInfo : serverInfoList) {
            if (serverInfo == null || !serverInfo.isValid() || serverInfo.getWeight() <= 0 || !((scaleTemp = (double)serverInfo.getAccessTimes().longValue() * 1.0 / (double)serverInfo.getWeight()) < scale)) continue;
            scale = scaleTemp;
            serverInfoTemp = serverInfo;
        }
        if (serverInfoTemp != null) {
            serverInfoTemp.incrAccessTimes();
        }
        return serverInfoTemp;
    }
}

