package cn.tuia.mango.core.domain;

import cn.tuia.mango.core.domain.page.PageParam;
import com.alibaba.fastjson.JSON;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.Date;

/**
 * @author lijicong
 * @since 2020-03-18
 */
@Getter
@Setter
public class BaseDomain implements Serializable {

    private static final long serialVersionUID = 5532782340259546999L;

    @ApiModelProperty(value = "主键")
    protected Long id;

    @ApiModelProperty(value = "创建时间")
    protected Date gmtCreate;

    @ApiModelProperty(value = "修改时间")
    protected Date gmtModified;

    @ApiModelProperty(value = "分页参数")
    protected PageParam pageParam;

    public void setCurrentAndSize(int current, int size) {
        if (pageParam == null) {
            this.pageParam = new PageParam(current, size);
        } else {
            this.pageParam.setCurrentAndSize(current, size);
        }
    }

    @Override
    public String toString() {
        return JSON.toJSONString(this);
    }
}
