package cn.tuia.mango.core.domain.api;

import cn.tuia.mango.core.enums.ResultCodeEnumerable;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

/**
 * @author lijicong
 * @since 2020-03-19
 */
@Setter
@Getter
@AllArgsConstructor
@NoArgsConstructor
public class ApiResult<T> implements Result<T> {

    private String code;
    private String desc;
    private T data;

    public ApiResult(String code, String desc) {
        this(code, desc, null);
    }

    public ApiResult(ResultCodeEnumerable resultCode) {
        this.code = resultCode.getCode();
        this.desc = resultCode.getDescription();
    }
}
