package cn.tuia.mango.core.domain.api;

import cn.tuia.mango.core.enums.CommonEnums.ResultCode;
import cn.tuia.mango.core.enums.ResultCodeEnumerable;

/**
 * @author lijicong
 * @since 2020-03-19
 */
public class Results {

    // 构造
    public static <T> ApiResult<T> success() {
        return new ApiResult<>(ResultCode.SUCCESS);
    }

    public static <T> ApiResult<T> success(T data) {
        ApiResult<T> result = new ApiResult<>(ResultCode.SUCCESS);
        result.setData(data);
        return result;
    }

    public static <T> ApiResult<T> success(T data, String desc) {
        ApiResult<T> result = new ApiResult<>(ResultCode.SUCCESS.getCode(), desc);
        result.setData(data);
        return result;
    }

    public static <T> ApiResult<T> fail(String code, String desc) {
        return new ApiResult<>(code, desc);
    }

    public static <T> ApiResult<T> fail(ResultCodeEnumerable resultCode) {
        return new ApiResult<>(resultCode);
    }

    // 判断
    public static <T> boolean isSuccess(ApiResult<T> result) {
        return result != null && ResultCode.SUCCESS.getCode().equals(result.getCode());
    }


    // 常见错误
    public static <T> ApiResult<T> badRequest() {
        return new ApiResult<>(ResultCode.BAD_REQUEST);
    }

    public static <T> ApiResult<T> unauthorized() {
        return new ApiResult<>(ResultCode.UNAUTHORIZED);
    }

    public static <T> ApiResult<T> forbidden() {
        return new ApiResult<>(ResultCode.FORBIDDEN);
    }

    public static <T> ApiResult<T> locked() {
        return new ApiResult<>(ResultCode.LOCKED);
    }

    public static <T> ApiResult<T> gatewayTimeout() {
        return new ApiResult<>(ResultCode.GATEWAY_TIMEOUT);
    }

}
