package cn.tuia.mango.core.domain.page;

import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;

import static java.util.stream.Collectors.toList;

/**
 * @author lijicong
 * @since 2020-03-23
 */
@NoArgsConstructor
@Setter
@Getter
public class PageData<T> implements Serializable {

    private static final long serialVersionUID = -9047332139853939943L;

    private long total;

    private List<T> records = Collections.emptyList();

    public PageData(long total, List<T> records) {
        this.total = total;
        if (records != null) {
            this.records = records;
        }
    }

    public void setRecords(List<T> records) {
        if (records != null) {
            this.records = records;
        }
    }

    public <R> PageData<R> convert(Function<? super T, ? extends R> mapper) {
        List<R> result = getRecords().stream().map(mapper).collect(toList());
        return new PageData<>(getTotal(), result);
    }
}
