package cn.tuia.mango.core.domain.page;

import java.io.Serializable;

/**
 * @author lijicong
 * @since 2020-03-23
 */
public class PageParam implements Serializable {

    private static final long serialVersionUID = -3408467501873488595L;

    public static final int DEFUALT_PAGESIZE = 20;
    public static final int DEFUALT_MAX_PAGESIZE = 500;

    /** 当前页 */
    private int current = 1;

    /** 每页大小 */
    private int size = DEFUALT_PAGESIZE;

    /** 偏移量 */
    private int offset = 0;

    public PageParam() {
    }

    public PageParam(int current, int size) {
        this.current = current;
        setSize(size);
    }

    public int getCurrent() {
        return current;
    }

    public void setCurrent(int current) {
        if (current < 1) {
            current = 1;
        }
        this.current = current;
        this.offset = (this.current - 1) * this.size;
    }

    public int getSize() {
        return size;
    }

    public void setSize(int size) {
        if (size > DEFUALT_MAX_PAGESIZE) {
            size = DEFUALT_MAX_PAGESIZE;
        }
        this.size = size;
        this.offset = (this.current - 1) * this.size;
    }

    public void setCurrentAndSize(int current, int size) {
        if (current < 1) {
            current = 1;
        }
        this.current = current;
        if (size > DEFUALT_MAX_PAGESIZE) {
            size = DEFUALT_MAX_PAGESIZE;
        }
        this.size = size;
        this.offset = (this.current - 1) * this.size;
    }

    public int getOffset() {
        return offset;
    }

    public void setOffset(int offset) {
        if (offset < 0) {
            offset = 0;
        }
        this.offset = offset;
        this.current = this.offset / this.size + 1;
    }
}
