package cn.tuia.mango.core.enums;

import java.util.concurrent.TimeUnit;

/**
 * 缓存枚举
 * @author lijicong
 * @since 2020-03-21
 */
public interface CacheEnumerable extends Enumerable {

    String getKey();

    int getTime();

    TimeUnit getUnit();

    default String getSpace() {
        return "MANGO";
    }

    String SEPARATOR = "-";

    default String generateKey(Object... keySuffix) {
        StringBuilder sb = new StringBuilder();
        sb.append(getSpace()).append(SEPARATOR).append(getKey());
        if (keySuffix != null) {
            for (Object temp : keySuffix) {
                sb.append(SEPARATOR);
                sb.append(temp);
            }
        }
        return sb.toString();
    }
}
